/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ReceiptLine;
import classes.TransactionTypes;
import classes.User;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class EditingCombobox
extends TableCell<ReceiptLine, TransactionTypes> {
    private ComboBox<TransactionTypes> textField;

    public EditingCombobox() {
        this.createTextField();
        this.startEdit();
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
        }
    }

    public ComboBox<TransactionTypes> getTextField() {
        return this.textField;
    }

    public void setTextField(ComboBox textField) {
        this.textField = textField;
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getItem() + "");
        this.setGraphic((Node)this.textField);
    }

    public void updateItem(TransactionTypes item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                // empty if block
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setGraphic((Node)this.textField);
        }
    }

    private void createTextField() {
        this.textField = new ComboBox();
        this.textField.setItems(new TransactionTypes().getTransactionTypes(1, new User()));
        this.textField.setValue((Object)this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.setPromptText("Transaction Type");
        this.textField.setMaxWidth(300.0);
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator(this.textField, Validator.createEmptyValidator((String)"Amount is required"));
        this.textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
            if (!arg2.booleanValue()) {
                try {
                    ReceiptLine line = (ReceiptLine)this.getTableRow().getItem();
                    System.out.println("No longer focused" + line.getLineNo());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    private TransactionTypes getString() {
        return this.getItem() == null ? null : (TransactionTypes)this.getItem();
    }
}

