/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ReceiptLine;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class EditingCell
extends TableCell<ReceiptLine, Double> {
    private TextField textField;

    public EditingCell() {
        this.createTextField();
        this.startEdit();
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public TextField getTextField() {
        return this.textField;
    }

    public void setTextField(TextField textField) {
        this.textField = textField;
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getItem() + "");
        this.setGraphic((Node)this.textField);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                // empty if block
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setGraphic((Node)this.textField);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString() + "");
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.textField, Validator.createEmptyValidator((String)"Amount is required"));
        this.textField.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
        this.textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
            if (!arg2.booleanValue()) {
                try {
                    this.commitEdit(Double.parseDouble(this.textField.getText()));
                    ReceiptLine line = (ReceiptLine)this.getTableRow().getItem();
                    System.out.println("No longer focused" + this.textField.getText() + line.getLineNo());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    private Double getString() {
        return this.getItem() == null ? Double.valueOf(0.0) : (Double)this.getItem();
    }
}

