/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Member;
import classes.User;
import classes.Vehicle;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class DriverConductor {
    private String employeeNo;
    private String name;
    private String idNo;
    private String phoneNo;
    private String email;
    private String position;
    private String licenseNo;
    private Member employer;
    private Vehicle vehicle;
    private boolean applied;
    private boolean badgeReceived;
    private boolean badgeIssued;
    private String issuedOn;
    private String expiry;
    private String nhifNumber;
    private String nssfNumber;

    public DriverConductor() {
    }

    public DriverConductor(String employeeNo, User user) {
        DriverConductor employee = new DriverConductor();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("employeeNo", employeeNo);
            String response = Config.loadDataFromPhp("masterfetch?type=driverconductor", params, user);
            DriverConductor[] employees = (DriverConductor[])new Gson().fromJson(response, DriverConductor[].class);
            employee = employees[0];
            this.employeeNo = employee.employeeNo;
            this.name = employee.name;
            this.idNo = employee.idNo;
            this.phoneNo = employee.phoneNo;
            this.email = employee.email;
            this.position = employee.position;
            this.licenseNo = employee.licenseNo;
            this.employer = employee.employer;
            this.vehicle = employee.vehicle;
            this.applied = employee.applied;
            this.badgeReceived = employee.badgeReceived;
            this.badgeIssued = employee.badgeIssued;
            this.issuedOn = employee.issuedOn;
            this.expiry = employee.expiry;
            this.nhifNumber = employee.nhifNumber;
            this.nssfNumber = employee.nssfNumber;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getEmployeeNo() {
        return this.employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdNo() {
        return this.idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public String getPhoneNo() {
        return this.phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getLicenseNo() {
        return this.licenseNo;
    }

    public void setLicenseNo(String licenseNo) {
        this.licenseNo = licenseNo;
    }

    public Member getEmployer() {
        return this.employer;
    }

    public void setEmployer(Member employer) {
        this.employer = employer;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public boolean isBadgeReceived() {
        return this.badgeReceived;
    }

    public void setBadgeReceived(boolean badgeReceived) {
        this.badgeReceived = badgeReceived;
    }

    public boolean isBadgeIssued() {
        return this.badgeIssued;
    }

    public void setBadgeIssued(boolean badgeIssued) {
        this.badgeIssued = badgeIssued;
    }

    public String getIssuedOn() {
        return this.issuedOn;
    }

    public void setIssuedOn(String issuedOn) {
        this.issuedOn = issuedOn;
    }

    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    public String getNhifNumber() {
        return this.nhifNumber;
    }

    public void setNhifNumber(String nhifNumber) {
        this.nhifNumber = nhifNumber;
    }

    public String getNssfNumber() {
        return this.nssfNumber;
    }

    public void setNssfNumber(String nssfNumber) {
        this.nssfNumber = nssfNumber;
    }

    public ObservableList<DriverConductor> allEmployees(User user) {
        ObservableList allEmployees = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=driverconductor", params, user);
            allEmployees = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, DriverConductor[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allEmployees;
    }

    public String toString() {
        return this.name;
    }
}

