/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Account;
import classes.AllowancesDeductions;
import classes.AppreciationDepreciation;
import classes.AssetAcquisition;
import classes.AssetDisposal;
import classes.BalanceSheet;
import classes.Bank;
import classes.BankTransfer;
import classes.CashWithdrawal;
import classes.ChequeRegister;
import classes.Contact;
import classes.ContactsGroup;
import classes.Customer;
import classes.CustomerReceipt;
import classes.Department;
import classes.DirectIncome;
import classes.DriverConductor;
import classes.Employee;
import classes.EmployeeBadge;
import classes.ItemBrand;
import classes.Journal;
import classes.JsonResponses;
import classes.LeaveApplication;
import classes.LeaveBalance;
import classes.LeaveType;
import classes.LedgerEntries;
import classes.Loan;
import classes.ManagementApproval;
import classes.MemberExit;
import classes.NumberSeries;
import classes.ParkingReceipt;
import classes.PaymentVoucher;
import classes.PettyCashVoucher;
import classes.PostingGroup;
import classes.ProductionReturn;
import classes.ProfitNLoss;
import classes.Project;
import classes.Property;
import classes.PublicHoliday;
import classes.PurchaseHeader;
import classes.Receipt;
import classes.RecoverLoan;
import classes.Region;
import classes.SalaryAdvance;
import classes.SalaryVoucher;
import classes.SalesHeader;
import classes.SalesLines;
import classes.ShopItem;
import classes.ShopLocation;
import classes.Sms;
import classes.StaffLoan;
import classes.StockConversion;
import classes.StockTake;
import classes.StockTransfer;
import classes.TaxGroup;
import classes.Tenant;
import classes.Town;
import classes.TransferFunds;
import classes.TransferVehicle;
import classes.UnitOfMeasure;
import classes.UnitTypes;
import classes.User;
import classes.UserRoles;
import classes.Vehicle;
import classes.VehicleBrands;
import classes.VehicleExit;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AccountSelectionController;
import controllers.AddExpressSale;
import controllers.AddHoliday;
import controllers.AddItemBrand;
import controllers.AddLeaveType;
import controllers.AddProperty;
import controllers.AddShopItem;
import controllers.AddShopLocation;
import controllers.AddStockTransfer;
import controllers.AddTaxGroup;
import controllers.AddTownController;
import controllers.AddUnitOfMeasure;
import controllers.AdjustLeaveDaysController;
import controllers.AllowancesController;
import controllers.BadgeApplicationController;
import controllers.BalanceSheetController;
import controllers.BankDiscrepancyController;
import controllers.BankLoanController;
import controllers.BankLoanRepaymentController;
import controllers.BankReconciliationController;
import controllers.BankTransferController;
import controllers.ChequeRegisterController;
import controllers.CommunicationChannelsController;
import controllers.CreateContact;
import controllers.CreateGroup;
import controllers.CreateMessage;
import controllers.CustomerCardController;
import controllers.CustomerInvoiceController;
import controllers.CustomerReceiptController;
import controllers.DeductionsController;
import controllers.DepartmentController;
import controllers.DirectIncomeController;
import controllers.DriverConductorController;
import controllers.EditUserRoleController;
import controllers.EditVehicleController;
import controllers.EmployeeCardController;
import controllers.EndOfDayController;
import controllers.FloorController;
import controllers.GeneralListController;
import controllers.ImprestVoucherController;
import controllers.InvestmentCommissionController;
import controllers.JournalCardController;
import controllers.LandlordDisbursementVoucher;
import controllers.LeaveApplicationForm;
import controllers.LoanRecoveryController;
import controllers.LoanTopupController;
import controllers.ManagementApprovalController;
import controllers.MemberExitController;
import controllers.NavigationController;
import controllers.ParkingFeeController;
import controllers.PaymentVoucherController;
import controllers.PettyCashVoucherController;
import controllers.PostingGroupController;
import controllers.PrepaymentsController;
import controllers.ProductionReturnController;
import controllers.ProfitNLossController;
import controllers.ProjectCardController;
import controllers.PropertyMonthlyChargesController;
import controllers.PurchaseHeaderController;
import controllers.RegionsController;
import controllers.ReportController;
import controllers.SalaryAdvanceForm;
import controllers.SalaryVoucherController;
import controllers.SalesOrderController;
import controllers.ShowGLEntries;
import controllers.StaffLoanForm;
import controllers.StockConversionController;
import controllers.StockTakeController;
import controllers.StoreRequestsController;
import controllers.TenantReceiptController;
import controllers.TransferFundsController;
import controllers.TransferVehicleController;
import controllers.UnitTypesController;
import controllers.UnitsController;
import controllers.UserRolesController;
import controllers.VehicleBrandsController;
import controllers.VehicleExitController;
import controllers.VendorCardController;
import controllers.WaterReadingController;
import controllers.appreciationController;
import controllers.assetAcquisitionController;
import controllers.assetDisposalController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import filterscontrollers.AllItemsFilterController;
import filterscontrollers.GLAccountFilter;
import filterscontrollers.MasterRollFilter;
import filterscontrollers.PNLFilter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.NotificationPane;

public class Config {
    public static int versionNo = 109;
    Double screenHeight = Screen.getPrimary().getVisualBounds().getHeight();
    Double screenWidth = Screen.getPrimary().getVisualBounds().getWidth();
    public static String saccoName = "KAIZEN AUTO GARAGE";
    public static String shortName = "KAIZEN";
    public static String companyAddress = Config.getShopAddress();
    public static boolean reprintReceipt = true;
    public static boolean editPrices = true;
    public static boolean hasPdc = false;
    public static boolean multiplePricesOnPOS = true;
    public static boolean eTIMSIntegration = false;
    public static boolean showVSMReports = true;
    public static boolean showRegionReports = false;
    public static boolean showDMSNo = true;
    public static boolean ERP_MODE = true;
    public static boolean DELIVERY_NOTE_PROMPT = false;
    public static boolean MANDATORY_CUSTOMER_REG = false;
    public static String errorStyle = "-fx-border-color:#b71c1c;-fx-border-width:2px;";

    public static String getURL() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 0) {
                    return line.replace("url:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getReportURL() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 1) {
                    return line.replace("reportLocation:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getAutoUpdateProgram() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 2) {
                    return line.replace("AutoUpdate:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getExeLocation() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 3) {
                    return line.replace("ExeLocation:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getShopLocation() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 4) {
                    return line.replace("ExeLocation:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getShopAddress() {
        if (ERP_MODE) {
            return "";
        }
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 5) {
                    return line.replace("ExeLocation:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getKRAPin() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 6) {
                    return line.replace("ExeLocation:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getBuyerKRAPinPrefix() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 7) {
                    return line.replace("ExeLocation:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String exportReportLocation() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        String credentials = path + "/credentials.txt";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(credentials));
            String line = reader.readLine();
            int count = 0;
            while (line != null) {
                if (count == 8) {
                    return line.replace("ExeLocation:", "");
                }
                ++count;
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getProgramRoot() {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        return path + "/";
    }

    public static void resetErrorStyle(Node node) {
        node.setStyle("-fx-border-width:0px; -fx-border-color:null;");
    }

    public static String formatNumber(double number) {
        DecimalFormat df2 = new DecimalFormat("0,000.00");
        return NumberFormat.getInstance().format(number);
    }

    public static double roundNumber(double number) {
        return (double)Math.round(number * 100.0) / 100.0;
    }

    public static String doubleToString(double number) {
        DecimalFormat df2 = new DecimalFormat("");
        String myNumber = NumberFormat.getInstance().format(number);
        return myNumber.replace(",", "");
    }

    public static ByteArrayOutputStream convertFileToJson(String fileName) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int readNum;
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            byte[] buf = new byte[1024];
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bos;
    }

    public void editRecord(String json, String type, final Stage stage, User user) {
        type = type.toLowerCase();
        boolean resizable = false;
        boolean applicationModality = true;
        try {
            Gson gson;
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = null;
            Gson g = gson = new Gson();
            switch (type) {
                case "transferfunds": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/transferfunds.fxml").openStream());
                    TransferFundsController controller = (TransferFundsController)loader.getController();
                    controller.setUser(user);
                    controller.setTransferFunds((TransferFunds)g.fromJson(json, TransferFunds.class));
                    stage.setTitle("Edit Transfer Funds Voucher");
                    break;
                }
                case "transfervehicle": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/transfervehicle.fxml").openStream());
                    TransferVehicleController controller = (TransferVehicleController)loader.getController();
                    controller.setUser(user);
                    controller.setTransferVehicle((TransferVehicle)g.fromJson(json, TransferVehicle.class));
                    stage.setTitle("Edit Transfer Vehicle Voucher");
                    break;
                }
                case "management_approval": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/managementapproval.fxml").openStream());
                    ManagementApprovalController controller = (ManagementApprovalController)loader.getController();
                    controller.setUser(user);
                    controller.setApproval((ManagementApproval)g.fromJson(json, ManagementApproval.class));
                    stage.setTitle("Edit Management Approval");
                    break;
                }
                case "stockrequest": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/storerequests.fxml").openStream());
                    StoreRequestsController controller = (StoreRequestsController)loader.getController();
                    controller.setUser(user);
                    controller.setHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    controller.setDocType("StockRequest");
                    stage.setTitle("Edit Store Request");
                    break;
                }
                case "endofday": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/end_of_day.fxml").openStream());
                    EndOfDayController controller = (EndOfDayController)loader.getController();
                    controller.setUser(user);
                    controller.setDocType("EndofDay");
                    controller.setHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit End of Day report");
                    break;
                }
                case "stock_conversion": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/stock_conversion.fxml").openStream());
                    StockConversionController controller = (StockConversionController)loader.getController();
                    controller.setUser(user);
                    controller.setStockConversion((StockConversion)g.fromJson(json, StockConversion.class));
                    stage.setTitle("Edit Stock Conversion");
                    break;
                }
                case "vehicleexit": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vehicleexit.fxml").openStream());
                    VehicleExitController controller = (VehicleExitController)loader.getController();
                    controller.setUser(user);
                    controller.setVehicleExit((VehicleExit)g.fromJson(json, VehicleExit.class));
                    stage.setTitle("Edit Vehicle Exit");
                    break;
                }
                case "driverconductor": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/driverconductor.fxml").openStream());
                    DriverConductorController controller = (DriverConductorController)loader.getController();
                    controller.setUser(user);
                    controller.setDriverConductor((DriverConductor)g.fromJson(json, DriverConductor.class));
                    stage.setTitle("Edit Employee");
                    break;
                }
                case "badgeapplication": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/badgeapplication.fxml").openStream());
                    BadgeApplicationController controller = (BadgeApplicationController)loader.getController();
                    controller.setUser(user);
                    controller.setBadge((EmployeeBadge)g.fromJson(json, EmployeeBadge.class));
                    stage.setTitle("Edit Badge application");
                    break;
                }
                case "loanrecovered": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/recoverloan.fxml").openStream());
                    LoanRecoveryController controller = (LoanRecoveryController)loader.getController();
                    controller.setUser(user);
                    controller.setRecoverLoan((RecoverLoan)g.fromJson(json, RecoverLoan.class));
                    stage.setTitle("Edit Recover Loan");
                    break;
                }
                case "memberexit": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/memberexit.fxml").openStream());
                    MemberExitController controller = (MemberExitController)loader.getController();
                    controller.setUser(user);
                    controller.setExit((MemberExit)g.fromJson(json, MemberExit.class));
                    stage.setTitle("Edit Member Exit");
                    break;
                }
                case "banktransfer": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/banktransfer.fxml").openStream());
                    BankTransferController controller = (BankTransferController)loader.getController();
                    controller.setUser(user);
                    controller.setBankTransfer((BankTransfer)g.fromJson(json, BankTransfer.class));
                    stage.setTitle("Edit Bank Transfer Voucher");
                    break;
                }
                case "tenantreceipt": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/tenantreceipt.fxml").openStream());
                    TenantReceiptController controller = (TenantReceiptController)loader.getController();
                    controller.setUser(user);
                    controller.setReceipt((CustomerReceipt)g.fromJson(json, CustomerReceipt.class));
                    stage.setTitle("Edit Tenant Receipt");
                    break;
                }
                case "landlorddisbursement": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/landlorddisbursement.fxml").openStream());
                    LandlordDisbursementVoucher controller = (LandlordDisbursementVoucher)loader.getController();
                    controller.setUser(user);
                    controller.setPaymentVoucher((PaymentVoucher)g.fromJson(json, PaymentVoucher.class));
                    stage.setTitle("Edit Disbursement");
                    break;
                }
                case "assetacquisition": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/assetAcquisition.fxml").openStream());
                    assetAcquisitionController controller = (assetAcquisitionController)loader.getController();
                    controller.setUser(user);
                    controller.setAcquisition((AssetAcquisition)g.fromJson(json, AssetAcquisition.class));
                    stage.setTitle("Edit Fixed Asset Acquisition");
                    break;
                }
                case "assetdisposal": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/assetDisposal.fxml").openStream());
                    assetDisposalController controller = (assetDisposalController)loader.getController();
                    controller.setUser(user);
                    controller.setAssetDisposal((AssetDisposal)g.fromJson(json, AssetDisposal.class));
                    stage.setTitle("Edit Fixed Asset Disposal");
                    break;
                }
                case "appreciationdepreciation": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/appreciation.fxml").openStream());
                    appreciationController controller = (appreciationController)loader.getController();
                    controller.setUser(user);
                    controller.setAppreciationDepreciation((AppreciationDepreciation)g.fromJson(json, AppreciationDepreciation.class));
                    stage.setTitle("EditAppreciation/Depreciation");
                    break;
                }
                case "vehiclebrands": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vehiclebrands.fxml").openStream());
                    VehicleBrandsController controller = (VehicleBrandsController)loader.getController();
                    controller.setUser(user);
                    controller.setVehicleBrands((VehicleBrands)g.fromJson(json, VehicleBrands.class));
                    stage.setTitle("Edit Vehicle Brand");
                    break;
                }
                case "vehicles": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/editVehicle.fxml").openStream());
                    EditVehicleController controller = (EditVehicleController)loader.getController();
                    controller.setUser(user);
                    controller.setVehicle((Vehicle)g.fromJson(json, Vehicle.class));
                    stage.setTitle("Edit Vehicle ");
                    break;
                }
                case "town": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/addtown.fxml").openStream());
                    AddTownController controller = (AddTownController)loader.getController();
                    controller.setUser(user);
                    controller.setTown((Town)g.fromJson(json, Town.class));
                    stage.setTitle("Edit Town ");
                    break;
                }
                case "parkingreceipts": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/parkingfeereceipt.fxml").openStream());
                    ParkingFeeController controller = (ParkingFeeController)loader.getController();
                    controller.setUser(user);
                    controller.setReceipt((ParkingReceipt)g.fromJson(json, ParkingReceipt.class));
                    stage.setTitle("Edit Parking Fee Receipt ");
                    break;
                }
                case "directincome": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/directincome.fxml").openStream());
                    DirectIncomeController controller = (DirectIncomeController)loader.getController();
                    controller.setUser(user);
                    controller.setIncome((DirectIncome)g.fromJson(json, DirectIncome.class));
                    break;
                }
                case "profitnloss": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/profitNLoss.fxml").openStream());
                    ProfitNLossController controller = (ProfitNLossController)loader.getController();
                    controller.setUser(user);
                    controller.setPnl((ProfitNLoss)g.fromJson(json, ProfitNLoss.class));
                    stage.setTitle("Edit Profit N Loss Statement");
                    break;
                }
                case "itembrand": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_item_brand.fxml").openStream());
                    AddItemBrand controller = (AddItemBrand)loader.getController();
                    controller.setUser(user);
                    controller.setItemBrand((ItemBrand)g.fromJson(json, ItemBrand.class));
                    stage.setTitle("Edit Item Brand");
                    break;
                }
                case "unitofmeasure": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_unit_of_measure.fxml").openStream());
                    AddUnitOfMeasure controller = (AddUnitOfMeasure)loader.getController();
                    controller.setUser(user);
                    controller.setUom((UnitOfMeasure)g.fromJson(json, UnitOfMeasure.class));
                    stage.setTitle("Edit Item Brand");
                    break;
                }
                case "shoplocation": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_shop_location.fxml").openStream());
                    AddShopLocation controller = (AddShopLocation)loader.getController();
                    controller.setUser(user);
                    controller.setLocation((ShopLocation)g.fromJson(json, ShopLocation.class));
                    stage.setTitle("Edit Warehouse");
                    break;
                }
                case "taxgroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_tax_group.fxml").openStream());
                    AddTaxGroup controller = (AddTaxGroup)loader.getController();
                    controller.setUser(user);
                    controller.setTaxGroup((TaxGroup)g.fromJson(json, TaxGroup.class));
                    stage.setTitle("Edit Tax Group");
                    break;
                }
                case "item": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_shop_item.fxml").openStream());
                    AddShopItem controller = (AddShopItem)loader.getController();
                    controller.setUser(user);
                    ShopItem item = (ShopItem)g.fromJson(json, ShopItem.class);
                    controller.setItem(item);
                    stage.setTitle("Edit Shop Item " + item.getName());
                    break;
                }
                case "expresssale": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_express_sale.fxml").openStream());
                    AddExpressSale controller = (AddExpressSale)loader.getController();
                    controller.setUser(user);
                    controller.setSale((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit Sale");
                    resizable = true;
                    break;
                }
                case "stocktransfer": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_stock_transfer.fxml").openStream());
                    AddStockTransfer controller = (AddStockTransfer)loader.getController();
                    controller.setUser(user);
                    controller.setStockTransfer((StockTransfer)g.fromJson(json, StockTransfer.class));
                    stage.setTitle("Edit Stock Transfer");
                    break;
                }
                case "contact": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/create_contact.fxml").openStream());
                    CreateContact controller = (CreateContact)loader.getController();
                    controller.setUser(user);
                    controller.setContact((Contact)g.fromJson(json, Contact.class));
                    stage.setTitle("Edit Contact");
                    break;
                }
                case "contactgroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/create_group.fxml").openStream());
                    CreateGroup controller = (CreateGroup)loader.getController();
                    controller.setUser(user);
                    ContactsGroup myGroup = (ContactsGroup)g.fromJson(json, ContactsGroup.class);
                    if (myGroup.isVirtualGroup()) {
                        GeneralListController.publicNotificationPane.setText("This is a virtual Group. It cannot be edited or deleted");
                        GeneralListController.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
                        GeneralListController.publicNotificationPane.show();
                        break;
                    }
                    controller.setGroup(myGroup);
                    stage.setTitle("Edit Group");
                    break;
                }
                case "balancesheet": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/balancesheet.fxml").openStream());
                    BalanceSheetController controller = (BalanceSheetController)loader.getController();
                    controller.setUser(user);
                    controller.setSheet((BalanceSheet)g.fromJson(json, BalanceSheet.class));
                    stage.setTitle("Edit Balance Sheet");
                    break;
                }
                case "sms": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/create_message.fxml").openStream());
                    CreateMessage controller = (CreateMessage)loader.getController();
                    controller.setUser(user);
                    controller.setSms((Sms)g.fromJson(json, Sms.class));
                    stage.setTitle("Edit Sms");
                    break;
                }
                case "journal": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/journalcard.fxml").openStream());
                    JournalCardController controller = (JournalCardController)loader.getController();
                    controller.setUser(user);
                    controller.setJournal((Journal)g.fromJson(json, Journal.class));
                    stage.setTitle("Edit Journal");
                    break;
                }
                case "property": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_property.fxml").openStream());
                    AddProperty controller = (AddProperty)loader.getController();
                    controller.setUser(user);
                    controller.setProperty((Property)g.fromJson(json, Property.class));
                    stage.setTitle("Edit Property");
                    break;
                }
                case "userrole": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/edituserrole.fxml").openStream());
                    EditUserRoleController controller = (EditUserRoleController)loader.getController();
                    controller.setUser(user);
                    controller.setUserRole((UserRoles)g.fromJson(json, UserRoles.class));
                    stage.setTitle("Edit User Role");
                    break;
                }
                case "lpo": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/purchase_header.fxml").openStream());
                    PurchaseHeaderController controller = (PurchaseHeaderController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.setInvoice((PurchaseHeader)g.fromJson(json, PurchaseHeader.class));
                    stage.setTitle("Edit Local Purchase Order");
                    break;
                }
                case "purchaseinvoice": 
                case "debitnote": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/purchase_header.fxml").openStream());
                    PurchaseHeaderController controller = (PurchaseHeaderController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.setInvoice((PurchaseHeader)g.fromJson(json, PurchaseHeader.class));
                    stage.setTitle("Edit Purchase Invoice");
                    resizable = true;
                    break;
                }
                case "unittype": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/unittypes.fxml").openStream());
                    UnitTypesController controller = (UnitTypesController)loader.getController();
                    controller.setUser(user);
                    controller.setUnitType((UnitTypes)g.fromJson(json, UnitTypes.class));
                    stage.setTitle("Edit Unit Type");
                    break;
                }
                case "generalvendor": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vendorcard.fxml").openStream());
                    VendorCardController controller = (VendorCardController)loader.getController();
                    controller.setUser(user);
                    controller.setVendorType("General Vendor");
                    controller.setVendor((Vendor)g.fromJson(json, Vendor.class));
                    stage.setTitle("Edit Vendor");
                    break;
                }
                case "salesrep": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vendorcard.fxml").openStream());
                    VendorCardController controller = (VendorCardController)loader.getController();
                    controller.setUser(user);
                    controller.setVendorType("Sales Rep");
                    controller.setVendor((Vendor)g.fromJson(json, Vendor.class));
                    break;
                }
                case "landlord": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vendorcard.fxml").openStream());
                    VendorCardController controller = (VendorCardController)loader.getController();
                    controller.setUser(user);
                    controller.setVendorType("Landlord");
                    controller.setVendor((Vendor)g.fromJson(json, Vendor.class));
                    stage.setTitle("Edit Landlord");
                    break;
                }
                case "region": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/regions.fxml").openStream());
                    RegionsController controller = (RegionsController)loader.getController();
                    controller.setUser(user);
                    controller.setRegion((Region)g.fromJson(json, Region.class));
                    stage.setTitle("Edit Region");
                    break;
                }
                case "project": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/projectCard.fxml").openStream());
                    ProjectCardController controller = (ProjectCardController)loader.getController();
                    controller.setUser(user);
                    controller.setProject((Project)g.fromJson(json, Project.class));
                    stage.setTitle("Edit Project");
                    break;
                }
                case "customer": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customercard.fxml").openStream());
                    CustomerCardController controller = (CustomerCardController)loader.getController();
                    controller.setUser(user);
                    controller.setCustomerType("generalCustomer");
                    controller.setCustomer((Customer)g.fromJson(json, Customer.class));
                    stage.setTitle("Edit Customer");
                    break;
                }
                case "tenant": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customercard.fxml").openStream());
                    CustomerCardController controller = (CustomerCardController)loader.getController();
                    controller.setUser(user);
                    controller.setCustomer((Customer)g.fromJson(json, Customer.class));
                    controller.setCustomerType("tenant");
                    stage.setTitle("Edit Tenant");
                    break;
                }
                case "pcv": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/pettycashcard.fxml").openStream());
                    PettyCashVoucherController controller = (PettyCashVoucherController)loader.getController();
                    controller.setUser(user);
                    controller.setPcv((PettyCashVoucher)g.fromJson(json, PettyCashVoucher.class));
                    stage.setTitle("Edit PCV");
                    break;
                }
                case "imprestvoucher": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/imprestvoucher.fxml").openStream());
                    ImprestVoucherController controller = (ImprestVoucherController)loader.getController();
                    controller.setUser(user);
                    controller.setImprest((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit Imprest Voucher");
                    break;
                }
                case "salesinvoice": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.setSalesHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit Customer Invoice");
                    applicationModality = false;
                    resizable = true;
                    break;
                }
                case "salesquote": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.setSalesHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit Quote");
                    applicationModality = false;
                    resizable = true;
                    break;
                }
                case "salesorder": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/sales_order.fxml").openStream());
                    SalesOrderController controller = (SalesOrderController)loader.getController();
                    controller.setUser(user);
                    controller.setDocType("SalesOrder");
                    controller.setHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit Sales Order");
                    break;
                }
                case "creditnote": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.setSalesHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit Credit Note");
                    applicationModality = false;
                    resizable = true;
                    break;
                }
                case "storerequisition": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.setSalesHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit Store Requisition");
                    applicationModality = false;
                    resizable = true;
                    break;
                }
                case "production_return": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/production_return.fxml").openStream());
                    ProductionReturnController controller = (ProductionReturnController)loader.getController();
                    controller.setUser(user);
                    controller.setProductionReturn((ProductionReturn)g.fromJson(json, ProductionReturn.class));
                    stage.setTitle("Edit Production Return");
                    applicationModality = false;
                    resizable = true;
                    break;
                }
                case "tenantinvoice": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType("tenantInvoice");
                    controller.setSalesHeader((SalesHeader)g.fromJson(json, SalesHeader.class));
                    stage.setTitle("Edit tenant Invoice");
                    break;
                }
                case "customerreceipt": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerreceipt.fxml").openStream());
                    CustomerReceiptController controller = (CustomerReceiptController)loader.getController();
                    controller.setUser(user);
                    controller.setReceipt((CustomerReceipt)g.fromJson(json, CustomerReceipt.class));
                    stage.setTitle("Edit Customer Receipt");
                    break;
                }
                case "prepayments": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/prepayments.fxml").openStream());
                    PrepaymentsController controller = (PrepaymentsController)loader.getController();
                    controller.setUser(user);
                    controller.setReceipt((CustomerReceipt)g.fromJson(json, CustomerReceipt.class));
                    stage.setTitle("Edit Prepayment");
                    break;
                }
                case "payment_voucher": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/paymentvoucher.fxml").openStream());
                    PaymentVoucherController controller = (PaymentVoucherController)loader.getController();
                    controller.setUser(user);
                    controller.setPaymentVoucher((PaymentVoucher)g.fromJson(json, PaymentVoucher.class));
                    stage.setTitle("Edit Payment Voucher");
                    break;
                }
                case "stock_take": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/stock_take.fxml").openStream());
                    StockTakeController controller = (StockTakeController)loader.getController();
                    controller.setUser(user);
                    controller.setStockTake((StockTake)g.fromJson(json, StockTake.class));
                    stage.setTitle("Edit Stock Take");
                    applicationModality = false;
                    resizable = true;
                    break;
                }
                case "bank_balance": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/bank_discrepancy.fxml").openStream());
                    BankDiscrepancyController controller = (BankDiscrepancyController)loader.getController();
                    controller.setUser(user);
                    controller.setBalance((Bank.BankBalance)g.fromJson(json, Bank.BankBalance.class));
                    stage.setTitle("Edit Bank balance");
                    break;
                }
                case "bank_loan": {
                    Account account = (Account)new Gson().fromJson(json, Account.class);
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/glentries.fxml").openStream());
                    ShowGLEntries controller = (ShowGLEntries)loader.getController();
                    controller.setUser(user);
                    controller.setGlAccount(account);
                    stage.setTitle("Show Entries");
                    break;
                }
                case "employee": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/employeeCard.fxml").openStream());
                    EmployeeCardController controller = (EmployeeCardController)loader.getController();
                    controller.setUser(user);
                    controller.setEmployee((Employee)gson.fromJson(json, Employee.class));
                    stage.setTitle("Edit Employee");
                    break;
                }
                case "department": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/department.fxml").openStream());
                    DepartmentController controller = (DepartmentController)loader.getController();
                    controller.setUser(user);
                    controller.setDepartment((Department)gson.fromJson(json, Department.class));
                    stage.setTitle("Edit Department");
                    break;
                }
                case "leavebalance": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/adjustleavedays.fxml").openStream());
                    AdjustLeaveDaysController controller = (AdjustLeaveDaysController)loader.getController();
                    controller.setUser(user);
                    controller.setBalance((LeaveBalance)gson.fromJson(json, LeaveBalance.class));
                    stage.setTitle("View Leave Days");
                    break;
                }
                case "leavetype": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_leave_type.fxml").openStream());
                    AddLeaveType controller = (AddLeaveType)loader.getController();
                    controller.setUser(user);
                    controller.setLeaveType((LeaveType)gson.fromJson(json, LeaveType.class));
                    stage.setTitle("Edit Leave Type");
                    break;
                }
                case "publicholiday": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_holiday.fxml").openStream());
                    AddHoliday controller = (AddHoliday)loader.getController();
                    controller.setUser(user);
                    controller.setPublicHoliday((PublicHoliday)gson.fromJson(json, PublicHoliday.class));
                    stage.setTitle("Edit Public Holiday");
                    break;
                }
                case "leaveapplication": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/leave_application_form.fxml").openStream());
                    LeaveApplicationForm controller = (LeaveApplicationForm)loader.getController();
                    controller.setUser(user);
                    controller.setLeaveApplication((LeaveApplication)gson.fromJson(json, LeaveApplication.class));
                    stage.setTitle("Edit Leave Application");
                    break;
                }
                case "payrollemployee": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/employeeCard.fxml").openStream());
                    EmployeeCardController controller = (EmployeeCardController)loader.getController();
                    controller.setPayroll(true);
                    controller.setUser(user);
                    controller.setEmployee((Employee)gson.fromJson(json, Employee.class));
                    stage.setTitle("Edit Employee");
                    break;
                }
                case "salaryvoucher": {
                    resizable = true;
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/salaryvoucher.fxml").openStream());
                    SalaryVoucherController controller = (SalaryVoucherController)loader.getController();
                    controller.setUser(user);
                    controller.setVoucher((SalaryVoucher)gson.fromJson(json, SalaryVoucher.class));
                    stage.setTitle("Edit Salary Voucher");
                    break;
                }
                case "salaryadvance": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/salary_advance_form.fxml").openStream());
                    SalaryAdvanceForm controller = (SalaryAdvanceForm)loader.getController();
                    controller.setUser(user);
                    controller.setSalaryAdvance((SalaryAdvance)gson.fromJson(json, SalaryAdvance.class));
                    stage.setTitle("Edit Salary Advance");
                    break;
                }
                case "staffloan": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/staffloan.fxml").openStream());
                    StaffLoanForm controller = (StaffLoanForm)loader.getController();
                    controller.setUser(user);
                    controller.setStaffLoan((StaffLoan)gson.fromJson(json, StaffLoan.class));
                    stage.setTitle("Edit Staff Loan");
                    break;
                }
                case "payrolldeductions": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/deductions.fxml").openStream());
                    DeductionsController controller = (DeductionsController)loader.getController();
                    controller.setUser(user);
                    controller.setDeduction((AllowancesDeductions)gson.fromJson(json, AllowancesDeductions.class));
                    stage.setTitle("Edit Deduction");
                    break;
                }
                case "payrollallowances": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allowances.fxml").openStream());
                    AllowancesController controller = (AllowancesController)loader.getController();
                    controller.setUser(user);
                    controller.setAllowance((AllowancesDeductions)gson.fromJson(json, AllowancesDeductions.class));
                    stage.setTitle("Edit Allowance");
                    break;
                }
                case "customer_cheque_register": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/cheque_register.fxml").openStream());
                    ChequeRegisterController controller = (ChequeRegisterController)loader.getController();
                    controller.setType(ChequeRegisterController.Type.CUSTOMER);
                    controller.setUser(user);
                    controller.setRegister((ChequeRegister)gson.fromJson(json, ChequeRegister.class));
                    stage.setTitle("Edit Cheque");
                    break;
                }
                case "vendor_cheque_register": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/cheque_register.fxml").openStream());
                    ChequeRegisterController controller = (ChequeRegisterController)loader.getController();
                    controller.setType(ChequeRegisterController.Type.VENDOR);
                    controller.setUser(user);
                    controller.setRegister((ChequeRegister)gson.fromJson(json, ChequeRegister.class));
                    stage.setTitle("Edit Cheque");
                    break;
                }
                case "itemspostinggroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/postinggroup.fxml").openStream());
                    PostingGroupController controller = (PostingGroupController)loader.getController();
                    controller.setType(3);
                    controller.setUser(user);
                    controller.setPostingGroup((PostingGroup)gson.fromJson(json, PostingGroup.class));
                    stage.setTitle("Edit Posting group");
                    break;
                }
                case "customerspostinggroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/postinggroup.fxml").openStream());
                    PostingGroupController controller = (PostingGroupController)loader.getController();
                    controller.setType(1);
                    controller.setUser(user);
                    controller.setPostingGroup((PostingGroup)gson.fromJson(json, PostingGroup.class));
                    stage.setTitle("Edit Posting group");
                    break;
                }
                case "vendorspostinggroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/postinggroup.fxml").openStream());
                    PostingGroupController controller = (PostingGroupController)loader.getController();
                    controller.setType(2);
                    controller.setUser(user);
                    controller.setPostingGroup((PostingGroup)gson.fromJson(json, PostingGroup.class));
                    stage.setTitle("Edit Posting group");
                    break;
                }
                default: {
                    GeneralListController.publicNotificationPane.setText(type + " has not been set");
                    GeneralListController.publicNotificationPane.setGraphic((Node)Config.getTimesIcon());
                    GeneralListController.publicNotificationPane.show();
                }
            }
            Scene scene = new Scene((Parent)itemPane, Math.min(itemPane.getPrefWidth(), this.screenWidth), Math.min(itemPane.getPrefHeight(), this.screenHeight));
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            stage.setResizable(resizable);
            if (applicationModality) {
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stage.showAndWait();
        }
        catch (Exception y) {
            GeneralListController.publicNotificationPane.setText("An error occurred while loading your edit record screen. Please contact support");
            GeneralListController.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
            GeneralListController.publicNotificationPane.show();
            y.printStackTrace();
        }
    }

    public JsonResponses deleteRecord(String json, String type, User user) {
        type = type.toLowerCase();
        JsonResponses jr = new JsonResponses();
        jr.setStatus(false);
        switch (type) {
            case "transferfunds": {
                try {
                    TransferFunds transfer = (TransferFunds)new Gson().fromJson(json, TransferFunds.class);
                    String transferNo = transfer.getTransferNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("transferNo", transferNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=transferfunds", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException transfer) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the transfer funds voucher");
                }
                return jr;
            }
            case "transfervehicle": {
                try {
                    TransferVehicle transfer = (TransferVehicle)new Gson().fromJson(json, TransferVehicle.class);
                    String transferNo = transfer.getTransferNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("transferNo", transferNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=transfervehicle", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException transfer) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the transfer vehicle voucher");
                }
                return jr;
            }
            case "vehicleexit": {
                try {
                    VehicleExit exit = (VehicleExit)new Gson().fromJson(json, VehicleExit.class);
                    String exitNo = exit.getExitNumber();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("exitNo", exitNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=vehicleexit", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException exit) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the vehicle exit voucher");
                }
                return jr;
            }
            case "driverconductor": {
                try {
                    DriverConductor conductor = (DriverConductor)new Gson().fromJson(json, DriverConductor.class);
                    String employeeNo = conductor.getEmployeeNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("employeeNo", employeeNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=driverconductor", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException conductor) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the employee");
                }
                return jr;
            }
            case "badgeapplication": {
                try {
                    EmployeeBadge badge = (EmployeeBadge)new Gson().fromJson(json, EmployeeBadge.class);
                    String applicationNo = badge.getApplicationNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("applicationNo", applicationNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=badgeapplication", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException badge) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the badge application");
                }
                return jr;
            }
            case "loanrecovered": {
                try {
                    RecoverLoan recovery = (RecoverLoan)new Gson().fromJson(json, RecoverLoan.class);
                    String recoveryNo = recovery.getRecoveryNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("recoveryNo", recoveryNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=loanrecovered", params, user);
                    System.out.println(response);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException recovery) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the loan recovery");
                }
                return jr;
            }
            case "memberexit": {
                try {
                    MemberExit exit = (MemberExit)new Gson().fromJson(json, MemberExit.class);
                    String exitNo = exit.getExitNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("exitNo", exitNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=memberexit", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException exit) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the member exit");
                }
                return jr;
            }
            case "banktransfer": {
                try {
                    BankTransfer transfer = (BankTransfer)new Gson().fromJson(json, BankTransfer.class);
                    String transferNo = transfer.getTransferNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("transferNo", transferNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=banktransfer", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException transfer) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the bank transfer voucher");
                }
                return jr;
            }
            case "assetacquisition": {
                try {
                    AssetAcquisition acquisition = (AssetAcquisition)new Gson().fromJson(json, AssetAcquisition.class);
                    String acquisitionNo = acquisition.getAcquisitionNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("acquisitionNo", acquisitionNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=assetacquisition", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException acquisition) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the asset acquisition voucher");
                }
                return jr;
            }
            case "assetdisposal": {
                try {
                    AssetDisposal disposal = (AssetDisposal)new Gson().fromJson(json, AssetDisposal.class);
                    String disposalNo = disposal.getDisposalNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("disposalNo", disposalNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=assetdisposal", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException disposal) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the asset disposal voucher");
                }
                return jr;
            }
            case "appreciationdepreciation": {
                try {
                    AppreciationDepreciation disposal = (AppreciationDepreciation)new Gson().fromJson(json, AppreciationDepreciation.class);
                    String voucherNo = disposal.getVoucherNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", voucherNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=appreciationdepreciation", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException disposal) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the appreciation/depreciation voucher");
                }
                return jr;
            }
            case "salaryvoucher": {
                try {
                    SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                    String voucherNo = voucher.getVoucherNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", voucherNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=salaryvoucher", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException voucher) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the salary voucher");
                }
                return jr;
            }
            case "vehiclebrands": {
                try {
                    VehicleBrands brand = (VehicleBrands)new Gson().fromJson(json, VehicleBrands.class);
                    int brandId = brand.getBrandId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("brandId", brandId);
                    String response = Config.loadDataFromPhp("masterdelete?type=vehiclebrands", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException brand) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the vehicle brand");
                }
                return jr;
            }
            case "town": {
                try {
                    Town town = (Town)new Gson().fromJson(json, Town.class);
                    int townId = town.getTownId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("townId", townId);
                    String response = Config.loadDataFromPhp("masterdelete?type=town", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException town) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the town");
                }
                return jr;
            }
            case "directincome": {
                try {
                    DirectIncome income = (DirectIncome)new Gson().fromJson(json, DirectIncome.class);
                    String voucherNo = income.getVoucherNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", voucherNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=directincome", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException income) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the direct income");
                }
                return jr;
            }
            case "profitnloss": {
                try {
                    ProfitNLoss income = (ProfitNLoss)new Gson().fromJson(json, ProfitNLoss.class);
                    int code = income.getCode();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("code", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=profitnloss", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException income) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the direct income");
                }
                return jr;
            }
            case "balancesheet": {
                try {
                    BalanceSheet sheet = (BalanceSheet)new Gson().fromJson(json, BalanceSheet.class);
                    int code = sheet.getCode();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("code", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=balancesheet", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException sheet) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the direct income");
                }
                return jr;
            }
            case "journal": {
                try {
                    Journal journal = (Journal)new Gson().fromJson(json, Journal.class);
                    String journalNo = journal.getJournalNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("journalNo", journalNo);
                    String response = Config.loadDataFromPhp("masterdelete?type=journal", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException journal) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the Journal");
                }
                return jr;
            }
            case "leaveapplication": {
                try {
                    LeaveApplication application = (LeaveApplication)new Gson().fromJson(json, LeaveApplication.class);
                    String code = application.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=leaveapplication", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException application) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the application");
                }
                return jr;
            }
            case "caretaker_leaveapplication": {
                try {
                    LeaveApplication application = (LeaveApplication)new Gson().fromJson(json, LeaveApplication.class);
                    String code = application.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=leaveapplication", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException application) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the application");
                }
                return jr;
            }
            case "salaryadvance": {
                try {
                    SalaryAdvance advance = (SalaryAdvance)new Gson().fromJson(json, SalaryAdvance.class);
                    String code = advance.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=salaryadvance", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException advance) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the advance");
                }
                return jr;
            }
            case "caretaker_salaryadvance": {
                try {
                    SalaryAdvance advance = (SalaryAdvance)new Gson().fromJson(json, SalaryAdvance.class);
                    String code = advance.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=salaryadvance", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException advance) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the advance");
                }
                return jr;
            }
            case "staffloan": {
                try {
                    StaffLoan loan = (StaffLoan)new Gson().fromJson(json, StaffLoan.class);
                    String code = loan.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=staffloan", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException loan) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the staff loan");
                }
                return jr;
            }
            case "caretaker_staffloan": {
                try {
                    StaffLoan loan = (StaffLoan)new Gson().fromJson(json, StaffLoan.class);
                    String code = loan.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=staffloan", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException loan) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the staff loan");
                }
                return jr;
            }
            case "publicholiday": {
                try {
                    PublicHoliday holiday = (PublicHoliday)new Gson().fromJson(json, PublicHoliday.class);
                    int code = holiday.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=publicholiday", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException holiday) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the holiday");
                }
                return jr;
            }
            case "leavetype": {
                try {
                    LeaveType holiday = (LeaveType)new Gson().fromJson(json, LeaveType.class);
                    int code = holiday.getNo();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=leavetype", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException holiday) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the leave type");
                }
                return jr;
            }
            case "payrollallowances": {
                try {
                    AllowancesDeductions allowance = (AllowancesDeductions)new Gson().fromJson(json, AllowancesDeductions.class);
                    String code = allowance.getCode();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("code", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=allowancededuction", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException allowance) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the allowance");
                }
                return jr;
            }
            case "payrolldeductions": {
                try {
                    AllowancesDeductions allowance = (AllowancesDeductions)new Gson().fromJson(json, AllowancesDeductions.class);
                    String code = allowance.getCode();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("code", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=allowancededuction", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException allowance) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the allowance");
                }
                return jr;
            }
            case "sms": {
                try {
                    Sms sms = (Sms)new Gson().fromJson(json, Sms.class);
                    String smsCode = sms.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("id", smsCode);
                    String response = Config.loadDataFromPhp("masterdelete?type=sms", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException sms) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the sms");
                }
                return jr;
            }
            case "contact": {
                try {
                    Contact contact = (Contact)new Gson().fromJson(json, Contact.class);
                    String contactCode = contact.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("contactCode", contactCode);
                    String response = Config.loadDataFromPhp("masterdelete?type=contact", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException contact) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the contact");
                }
                return jr;
            }
            case "userrole": {
                try {
                    UserRoles userRole = (UserRoles)new Gson().fromJson(json, UserRoles.class);
                    int roleId = userRole.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("roleId", roleId);
                    String response = Config.loadDataFromPhp("masterdelete?type=userrole", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException userRole) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the user role");
                }
                return jr;
            }
            case "contactgroup": {
                try {
                    ContactsGroup group = (ContactsGroup)new Gson().fromJson(json, ContactsGroup.class);
                    if (group.isVirtualGroup()) {
                        jr.setMessage("This is a virtual Group. It cannot be edited or deleted");
                        jr.setStatus(false);
                        return jr;
                    }
                    String groupCode = group.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("groupCode", groupCode);
                    String response = Config.loadDataFromPhp("masterdelete?type=contactgroup", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (NullPointerException group) {
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the Group");
                }
                return jr;
            }
            case "unittype": {
                try {
                    UnitTypes unitType = (UnitTypes)new Gson().fromJson(json, UnitTypes.class);
                    int typeId = unitType.getId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("typeId", typeId);
                    String response = Config.loadDataFromPhp("masterdelete?type=unittype", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the unit type");
                }
                return jr;
            }
            case "tenant": {
                try {
                    Tenant tenant = (Tenant)new Gson().fromJson(json, Tenant.class);
                    String tenantCode = tenant.getCustomer().getCustomerNumber();
                    int unitCode = tenant.getUnit().getUnitId();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("unitCode", unitCode);
                    params.put("tenantCode", tenantCode);
                    String response = Config.loadDataFromPhp("masterdelete?type=tenant", params, user);
                    jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                }
                catch (Exception t) {
                    jr.setStatus(false);
                    jr.setMessage("We encountered an error while deleting the tenant");
                }
                return jr;
            }
        }
        return jr;
    }

    public void newRecord(String type, final Stage stage, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            boolean resizable = false;
            boolean applicationModality = true;
            VBox itemPane = null;
            switch (type) {
                case "transferfunds": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/transferfunds.fxml").openStream());
                    TransferFundsController controller = (TransferFundsController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Funds Transfer");
                    break;
                }
                case "transfervehicle": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/transfervehicle.fxml").openStream());
                    TransferVehicleController controller = (TransferVehicleController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Vehicle Transfer");
                    break;
                }
                case "stockrequest": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/storerequests.fxml").openStream());
                    StoreRequestsController controller = (StoreRequestsController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Store Request");
                    break;
                }
                case "vehicleexit": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vehicleexit.fxml").openStream());
                    VehicleExitController controller = (VehicleExitController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Vehicle Exit");
                    break;
                }
                case "memberexit": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/memberexit.fxml").openStream());
                    MemberExitController controller = (MemberExitController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Member Exit");
                    break;
                }
                case "driverconductor": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/driverconductor.fxml").openStream());
                    DriverConductorController controller = (DriverConductorController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Employee");
                    break;
                }
                case "badgeapplication": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/badgeapplication.fxml").openStream());
                    BadgeApplicationController controller = (BadgeApplicationController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Badge Application");
                    break;
                }
                case "loanrecovered": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/recoverloan.fxml").openStream());
                    LoanRecoveryController controller = (LoanRecoveryController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Loan Recovery");
                    break;
                }
                case "vehiclebrands": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vehiclebrands.fxml").openStream());
                    VehicleBrandsController controller = (VehicleBrandsController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Vehicle Brand");
                    break;
                }
                case "directincome": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/directincome.fxml").openStream());
                    DirectIncomeController controller = (DirectIncomeController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Direct Income");
                    break;
                }
                case "banktransfer": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/banktransfer.fxml").openStream());
                    BankTransferController controller = (BankTransferController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Bank Transfer");
                    break;
                }
                case "bankbalances": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/bank_discrepancy.fxml").openStream());
                    BankDiscrepancyController controller = (BankDiscrepancyController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New BanK Balance");
                    break;
                }
                case "profitnloss": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/profitNLoss.fxml").openStream());
                    ProfitNLossController controller = (ProfitNLossController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Profit and Loss ");
                    break;
                }
                case "balancesheet": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/balancesheet.fxml").openStream());
                    BalanceSheetController controller = (BalanceSheetController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Balance Sheet");
                    break;
                }
                case "loantopup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loantopup.fxml").openStream());
                    LoanTopupController controller = (LoanTopupController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Loan Top Up");
                    break;
                }
                case "town": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/addtown.fxml").openStream());
                    AddTownController controller = (AddTownController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Town");
                    break;
                }
                case "parkingreceipts": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/parkingfeereceipt.fxml").openStream());
                    ParkingFeeController controller = (ParkingFeeController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Receipt");
                    break;
                }
                case "investmentcommissions": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/investmentcommission.fxml").openStream());
                    InvestmentCommissionController controller = (InvestmentCommissionController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Commission");
                    break;
                }
                case "assetacquisition": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/assetAcquisition.fxml").openStream());
                    assetAcquisitionController controller = (assetAcquisitionController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Asset Acquisition");
                    break;
                }
                case "assetdisposal": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/assetDisposal.fxml").openStream());
                    assetDisposalController controller = (assetDisposalController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Asset Disposal");
                    break;
                }
                case "appreciationdepreciation": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/appreciation.fxml").openStream());
                    appreciationController controller = (appreciationController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Appreciation/Depreciation");
                    break;
                }
                case "itembrand": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_item_brand.fxml").openStream());
                    AddItemBrand controller = (AddItemBrand)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Item Brand");
                    break;
                }
                case "taxgroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_tax_group.fxml").openStream());
                    AddTaxGroup controller = (AddTaxGroup)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Tax Group");
                    break;
                }
                case "unitofmeasure": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_unit_of_measure.fxml").openStream());
                    AddUnitOfMeasure controller = (AddUnitOfMeasure)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Unit of Measure");
                    break;
                }
                case "item": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_shop_item.fxml").openStream());
                    AddShopItem controller = (AddShopItem)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Add Item");
                    break;
                }
                case "shoplocation": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_shop_location.fxml").openStream());
                    AddShopLocation controller = (AddShopLocation)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Create Warehouse");
                    break;
                }
                case "stocktransfer": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_stock_transfer.fxml").openStream());
                    AddStockTransfer controller = (AddStockTransfer)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Add Stock Transfer");
                    break;
                }
                case "expresssale": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_express_sale.fxml").openStream());
                    AddExpressSale controller = (AddExpressSale)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Sale");
                    resizable = true;
                    break;
                }
                case "sms": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/create_message.fxml").openStream());
                    CreateMessage controller = (CreateMessage)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Compose Message");
                    break;
                }
                case "contact": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/create_contact.fxml").openStream());
                    CreateContact controller = (CreateContact)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Add Contact");
                    break;
                }
                case "contactgroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/create_group.fxml").openStream());
                    CreateGroup controller = (CreateGroup)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Add Group");
                    break;
                }
                case "journal": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/journalcard.fxml").openStream());
                    JournalCardController controller = (JournalCardController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Journal");
                    break;
                }
                case "property": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_property.fxml").openStream());
                    AddProperty controller = (AddProperty)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Property");
                    break;
                }
                case "userrole": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/userrole.fxml").openStream());
                    UserRolesController controller = (UserRolesController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Role");
                    break;
                }
                case "lpo": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/purchase_header.fxml").openStream());
                    PurchaseHeaderController controller = (PurchaseHeaderController)loader.getController();
                    controller.setDocumentType(type);
                    controller.setUser(user);
                    resizable = true;
                    stage.setTitle("New LPO");
                    break;
                }
                case "purchaseInvoice": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/purchase_header.fxml").openStream());
                    PurchaseHeaderController controller = (PurchaseHeaderController)loader.getController();
                    controller.setDocumentType(type);
                    controller.setUser(user);
                    stage.setTitle("New Purchase Invoice");
                    resizable = true;
                    break;
                }
                case "debitNote": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/purchase_header.fxml").openStream());
                    PurchaseHeaderController controller = (PurchaseHeaderController)loader.getController();
                    controller.setDocumentType(type);
                    controller.setUser(user);
                    stage.setTitle("New Debit Note");
                    resizable = true;
                    break;
                }
                case "unittype": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/unittypes.fxml").openStream());
                    UnitTypesController controller = (UnitTypesController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Unit Type");
                    break;
                }
                case "generalvendor": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vendorcard.fxml").openStream());
                    VendorCardController controller = (VendorCardController)loader.getController();
                    controller.setUser(user);
                    controller.setVendorType("General Vendor");
                    stage.setTitle("Add Vendor");
                    break;
                }
                case "salesRep": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vendorcard.fxml").openStream());
                    VendorCardController controller = (VendorCardController)loader.getController();
                    controller.setUser(user);
                    controller.setVendorType("Sales Rep");
                    stage.setTitle("Add Sales Rep");
                    break;
                }
                case "landlord": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vendorcard.fxml").openStream());
                    VendorCardController controller = (VendorCardController)loader.getController();
                    controller.setUser(user);
                    controller.setVendorType("Landlord");
                    stage.setTitle("Create Landlord");
                    break;
                }
                case "region": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/regions.fxml").openStream());
                    RegionsController controller = (RegionsController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Create Region");
                    break;
                }
                case "project": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/projectCard.fxml").openStream());
                    ProjectCardController controller = (ProjectCardController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Create Project");
                    break;
                }
                case "customer": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customercard.fxml").openStream());
                    CustomerCardController controller = (CustomerCardController)loader.getController();
                    controller.setUser(user);
                    controller.setCustomerType("generalCustomer");
                    stage.setTitle("Add Customer");
                    break;
                }
                case "tenant": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customercard.fxml").openStream());
                    CustomerCardController controller = (CustomerCardController)loader.getController();
                    controller.setUser(user);
                    controller.setCustomerType("tenant");
                    stage.setTitle("Add Tenant");
                    break;
                }
                case "landlorddisbursement": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/landlorddisbursement.fxml").openStream());
                    LandlordDisbursementVoucher controller = (LandlordDisbursementVoucher)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Disbursement");
                    break;
                }
                case "waterreading": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/waterreading.fxml").openStream());
                    WaterReadingController controller = (WaterReadingController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Water Reading");
                    break;
                }
                case "pcv": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/pettycashcard.fxml").openStream());
                    PettyCashVoucherController controller = (PettyCashVoucherController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Petty Cash Voucher");
                    break;
                }
                case "imprestvoucher": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/imprestvoucher.fxml").openStream());
                    ImprestVoucherController controller = (ImprestVoucherController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Imprest Voucher");
                    break;
                }
                case "salesInvoice": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    resizable = true;
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.loadFiles("");
                    stage.setTitle("New Customer Invoice");
                    break;
                }
                case "stock_conversion": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/stock_conversion.fxml").openStream());
                    StockConversionController controller = (StockConversionController)loader.getController();
                    resizable = true;
                    controller.setUser(user);
                    controller.loadValues();
                    stage.setTitle("New Stock Conversion");
                    break;
                }
                case "SalesQuote": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    resizable = true;
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    stage.setTitle("New Sales Quote");
                    controller.loadFiles("");
                    break;
                }
                case "CreditNote": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    resizable = true;
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    controller.loadFiles("");
                    stage.setTitle("Edit CreditNote");
                    break;
                }
                case "StoreRequisition": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    resizable = true;
                    controller.setUser(user);
                    controller.setDocumentType(type);
                    stage.setTitle("New Store Requisition");
                    controller.loadFiles("");
                    break;
                }
                case "production_return": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/production_return.fxml").openStream());
                    ProductionReturnController controller = (ProductionReturnController)loader.getController();
                    controller.setUser(user);
                    controller.loadItems();
                    stage.setTitle("New Production Return");
                    break;
                }
                case "proformaInvoice": {
                    resizable = true;
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType("sales_invoice");
                    stage.setTitle("New Proforma Invoice");
                    controller.loadFiles("");
                    break;
                }
                case "tenantInvoice": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerInvoice.fxml").openStream());
                    CustomerInvoiceController controller = (CustomerInvoiceController)loader.getController();
                    controller.setUser(user);
                    controller.setDocumentType("tenantInvoice");
                    stage.setTitle("New Tenant Invoice");
                    controller.loadFiles("");
                    break;
                }
                case "customerreceipt": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerreceipt.fxml").openStream());
                    CustomerReceiptController controller = (CustomerReceiptController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Customer Receipt");
                    break;
                }
                case "prepayments": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/prepayments.fxml").openStream());
                    PrepaymentsController controller = (PrepaymentsController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Prepayment");
                    break;
                }
                case "payment_voucher": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/paymentvoucher.fxml").openStream());
                    PaymentVoucherController controller = (PaymentVoucherController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Payment Voucher");
                    break;
                }
                case "stock_take": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/stock_take.fxml").openStream());
                    StockTakeController controller = (StockTakeController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Stock Take");
                    applicationModality = false;
                    resizable = true;
                    break;
                }
                case "tenantreceipt": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/tenantreceipt.fxml").openStream());
                    TenantReceiptController controller = (TenantReceiptController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Tenant Receipt");
                    break;
                }
                case "communicationchannels": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/communication_channels.fxml").openStream());
                    CommunicationChannelsController controller = (CommunicationChannelsController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Communication Channel");
                    break;
                }
                case "bankreconciliation": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/bankreconciliation.fxml").openStream());
                    BankReconciliationController controller = (BankReconciliationController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Bank Reconciliation");
                    break;
                }
                case "bank_balance": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/bank_discrepancy.fxml").openStream());
                    BankDiscrepancyController controller = (BankDiscrepancyController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Bank Balance");
                    break;
                }
                case "bank_loan": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/bank_loan.fxml").openStream());
                    BankLoanController controller = (BankLoanController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Bank Loan");
                    break;
                }
                case "employee": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/employeeCard.fxml").openStream());
                    EmployeeCardController controller = (EmployeeCardController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Employee");
                    break;
                }
                case "department": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/department.fxml").openStream());
                    DepartmentController controller = (DepartmentController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Department");
                    break;
                }
                case "leaveapplication": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/leave_application_form.fxml").openStream());
                    LeaveApplicationForm controller = (LeaveApplicationForm)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Leave Application");
                    break;
                }
                case "leavebalance": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/adjustleavedays.fxml").openStream());
                    AdjustLeaveDaysController controller = (AdjustLeaveDaysController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Adjust Leave Days");
                    break;
                }
                case "leavetype": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_leave_type.fxml").openStream());
                    AddLeaveType controller = (AddLeaveType)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Add Leave Type");
                    break;
                }
                case "publicholiday": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/add_holiday.fxml").openStream());
                    AddHoliday controller = (AddHoliday)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Add Public Holiday");
                    break;
                }
                case "salaryadvance": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/salary_advance_form.fxml").openStream());
                    SalaryAdvanceForm controller = (SalaryAdvanceForm)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Salary Advance Form");
                    break;
                }
                case "staffloan": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/staffloan.fxml").openStream());
                    StaffLoanForm controller = (StaffLoanForm)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("Staff Loan");
                    break;
                }
                case "payrolldeductions": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/deductions.fxml").openStream());
                    DeductionsController controller = (DeductionsController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Deduction");
                    break;
                }
                case "salaryvoucher": {
                    resizable = true;
                    applicationModality = false;
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/salaryvoucher.fxml").openStream());
                    SalaryVoucherController controller = (SalaryVoucherController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Salary Voucher");
                    break;
                }
                case "payrollallowances": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allowances.fxml").openStream());
                    AllowancesController controller = (AllowancesController)loader.getController();
                    controller.setUser(user);
                    stage.setTitle("New Allowance");
                    break;
                }
                case "customer_cheque_register": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/cheque_register.fxml").openStream());
                    ChequeRegisterController controller = (ChequeRegisterController)loader.getController();
                    controller.setType(ChequeRegisterController.Type.CUSTOMER);
                    controller.setUser(user);
                    stage.setTitle("New Cheque");
                    break;
                }
                case "vendor_cheque_register": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/cheque_register.fxml").openStream());
                    ChequeRegisterController controller = (ChequeRegisterController)loader.getController();
                    controller.setType(ChequeRegisterController.Type.VENDOR);
                    controller.setUser(user);
                    stage.setTitle("New Cheque");
                    break;
                }
                case "itemspostinggroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/postinggroup.fxml").openStream());
                    PostingGroupController controller = (PostingGroupController)loader.getController();
                    controller.setType(3);
                    controller.setUser(user);
                    stage.setTitle("New Posting group");
                    break;
                }
                case "customerspostinggroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/postinggroup.fxml").openStream());
                    PostingGroupController controller = (PostingGroupController)loader.getController();
                    controller.setType(1);
                    controller.setUser(user);
                    stage.setTitle("New Posting group");
                    break;
                }
                case "vendorspostinggroup": {
                    itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/postinggroup.fxml").openStream());
                    PostingGroupController controller = (PostingGroupController)loader.getController();
                    controller.setType(2);
                    controller.setUser(user);
                    stage.setTitle("New Posting group");
                    break;
                }
            }
            Scene scene = new Scene((Parent)itemPane, Math.min(itemPane.getPrefWidth(), this.screenWidth), Math.min(itemPane.getPrefHeight(), this.screenHeight));
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            stage.setResizable(resizable);
            if (applicationModality) {
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stage.showAndWait();
        }
        catch (Exception p) {
            GeneralListController.publicNotificationPane.setText("An error occurred while loading your new record screen. Please contact support");
            GeneralListController.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
            GeneralListController.publicNotificationPane.show();
            p.printStackTrace();
        }
    }

    public void generateReport(String reportName, String json, User user) {
        switch (reportName = reportName.toLowerCase()) {
            case "masterroll": {
                SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("reportName", "Master Roll for The Period " + voucher.getMonth().getMonthName() + " " + voucher.getYear().getYear());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                params.put("month", voucher.getMonth().getCode());
                params.put("year", voucher.getYear().getYear());
                new Config().getReport("Master Roll", "masterfetch?type=masterroll", params, "masterroll.jasper", reportVariables, user);
                return;
            }
            case "bank_export": {
                SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                params.put("month", voucher.getMonth().getCode());
                params.put("year", voucher.getYear().getYear());
                Stage stage = new Stage();
                new MasterRollFilter().getBankExport(stage, params, user);
                return;
            }
            case "paye_export": {
                SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                params.put("month", voucher.getMonth().getCode());
                params.put("year", voucher.getYear().getYear());
                Stage stage = new Stage();
                new MasterRollFilter().getPAYEExport(stage, params, user);
                return;
            }
            case "nhif_export": {
                SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                params.put("month", voucher.getMonth().getCode());
                params.put("year", voucher.getYear().getYear());
                Stage stage = new Stage();
                new MasterRollFilter().getNHIFExport(stage, params, user);
                return;
            }
            case "nssf_export": {
                SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                params.put("month", voucher.getMonth().getCode());
                params.put("year", voucher.getYear().getYear());
                Stage stage = new Stage();
                new MasterRollFilter().getNSSFExport(stage, params, user);
                return;
            }
            case "payroll_summary": {
                SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("reportName", "Payroll Summary for The Period " + voucher.getMonth().getMonthName() + " " + voucher.getYear().getYear());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                params.put("month", voucher.getMonth().getCode());
                params.put("year", voucher.getYear().getYear());
                new Config().getReport("Payroll Summary", "masterfetch?type=payrollsummary", params, "payrollsummary.jasper", reportVariables, user);
                return;
            }
            case "all_payslips": {
                SalaryVoucher voucher = (SalaryVoucher)new Gson().fromJson(json, SalaryVoucher.class);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("period", voucher.getMonth().getMonthName() + " " + voucher.getYear().getYear());
                reportVariables.put("reportName", "Payslip " + voucher.getMonth().getMonthName() + " " + voucher.getYear().getYear());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                params.put("month", voucher.getMonth().getCode());
                params.put("year", voucher.getYear().getYear());
                new Config().getReport("All Payslips", "masterfetch?type=allpayslips", params, "allpayslips.jasper", reportVariables, user);
                return;
            }
            case "member exit form": {
                System.out.println("Am here");
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", saccoName);
                new Config().getReportWithJson("Member Exit Form", json, "memberexit.jasper", reportVariables);
                return;
            }
            case "expresssale": {
                SalesHeader sale = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("servedBy", user.getUserName());
                reportVariables.put("printedOn", "Printed on " + Config.getSystemTime());
                reportVariables.put("kraPIN", Config.getKRAPin());
                reportVariables.put("buyerKraPin", Config.getBuyerKRAPinPrefix() + sale.getCustomerPin());
                reportVariables.put("address", companyAddress);
                reportVariables.put("receiptNo", sale.getDoc_no());
                reportVariables.put("receiptDate", sale.getSales_date());
                reportVariables.put("saleDate", sale.getSales_date());
                reportVariables.put("customerName", sale.getCustomerName());
                reportVariables.put("customerPin", sale.getCustomerPin());
                reportVariables.put("address", companyAddress);
                if (eTIMSIntegration) {
                    try {
                        reportVariables.put("qrCode", sale.getQrCode());
                        reportVariables.put("cuSerialNo", sale.getSerialNo());
                        reportVariables.put("cuInvoiceNo", sale.getCuInvoiceNo());
                        reportVariables.put("internalData", sale.getInternalData());
                        reportVariables.put("receiptSignature", sale.getReceiptSignature());
                    }
                    catch (Exception u) {
                        u.printStackTrace();
                    }
                }
                String data = new Gson().toJson(new SalesLines().getAllLines(sale.getDoc_no(), AddExpressSale.DOCUMENT_TYPE, user));
                new Config().getReportWithJson("Express Sale", data, "expresssale58mm.jasper", reportVariables);
                return;
            }
            case "salaryadvancevoucher": {
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                SalaryAdvance advance = (SalaryAdvance)new Gson().fromJson(json, SalaryAdvance.class);
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("address", companyAddress);
                reportVariables.put("voucherTitle", "Salary Advance Voucher");
                reportVariables.put("voucherNo", "VOUCHER NO.: " + advance.getId());
                reportVariables.put("payee", "PAYEE NAME: " + advance.getEmployee().getFullName());
                reportVariables.put("chequeNo", advance.getExtDocNo());
                reportVariables.put("preparedBy", user.getUserName());
                reportVariables.put("voucherDate", "DATE: " + advance.getDate());
                LinkedHashMap<String, Object> lines = new LinkedHashMap<String, Object>();
                lines.put("particularsOfPayment", "Salary Advance");
                lines.put("description", "Salary Advance to " + advance.getEmployee().getFullName());
                lines.put("amount", advance.getAmount());
                String data = new Gson().toJson(lines);
                new Config().getReportWithJson("Salary Advance Voucher", data, "voucher.jasper", reportVariables);
                return;
            }
            case "staffloanvoucher": {
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                StaffLoan advance = (StaffLoan)new Gson().fromJson(json, StaffLoan.class);
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("address", companyAddress);
                reportVariables.put("voucherTitle", "Staff Loan Voucher");
                reportVariables.put("voucherNo", "VOUCHER NO.: " + advance.getId());
                reportVariables.put("payee", "PAYEE NAME: " + advance.getEmployee().getFullName());
                reportVariables.put("chequeNo", advance.getExtDocNo());
                reportVariables.put("preparedBy", user.getUserName());
                reportVariables.put("voucherDate", "DATE: " + advance.getDate());
                LinkedHashMap<String, Object> lines = new LinkedHashMap<String, Object>();
                lines.put("particularsOfPayment", "Staff Loan");
                lines.put("description", "Staff Loan to " + advance.getEmployee().getFullName());
                lines.put("amount", advance.getAmount());
                String data = new Gson().toJson(lines);
                new Config().getReportWithJson("Staff Loan Voucher", data, "voucher.jasper", reportVariables);
                return;
            }
            case "vendorstatement": {
                this.loadVendorPNLFilter(reportName, json, "Vendor Statement", user);
                return;
            }
            case "landlordstatement": {
                Vendor vendor = (Vendor)new Gson().fromJson(json, Vendor.class);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("vendorName", vendor.getFullName());
                reportVariables.put("vendorPhone", vendor.getVendorPhone());
                reportVariables.put("vendorEmail", vendor.getVendorEmail());
                reportVariables.put("saccoName", saccoName);
                LinkedHashMap<String, Object> dataVariables = new LinkedHashMap<String, Object>();
                dataVariables.put("vendorNo", vendor.getVendorNumber());
                new Config().getReport("Landlord Statement", "masterfetch?type=landlordstatement", dataVariables, "landlordstatement.jasper", reportVariables, user);
                return;
            }
            case "customer_statement_products": {
                this.loadCustomerPNLFilter(reportName, json, "Customer Statement Products Filter", user);
                return;
            }
            case "dms_products": {
                this.loadCustomerPNLFilter(reportName, json, "DMS Products Statement Filter", user);
                return;
            }
            case "customerstatement": {
                this.loadCustomerPNLFilter(reportName, json, "Customer Statement", user);
                return;
            }
            case "gl_account_statement": {
                Account account = (Account)new Gson().fromJson(json, Account.class);
                try {
                    Stage stage = new Stage();
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/glaccountfilter.fxml").openStream());
                    Scene scene = new Scene((Parent)itemPane);
                    scene.setOnKeyPressed(t -> {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    });
                    stage.setScene(scene);
                    GLAccountFilter controller = (GLAccountFilter)loader.getController();
                    controller.setAccount(account);
                    controller.setUser(user);
                    controller.setReportName("accountstatement");
                    stage.setTitle("View G/L Account Statement");
                    stage.setResizable(false);
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.showAndWait();
                }
                catch (NullPointerException t2) {
                    t2.printStackTrace();
                }
                catch (Exception i) {
                    i.printStackTrace();
                }
                return;
            }
            case "tenantagreement": {
                Customer customer = (Customer)new Gson().fromJson(json, Customer.class);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, Object> dataVariables = new LinkedHashMap<String, Object>();
                dataVariables.put("customerNo", customer.getCustomerNumber());
                new Config().getReport("Tenant Agreement", "masterfetch?type=tenantagreement", dataVariables, "tenantagreement.jasper", reportVariables, user);
                return;
            }
            case "pcvvoucher": {
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                PettyCashVoucher pettyCashVoucher = (PettyCashVoucher)new Gson().fromJson(json, PettyCashVoucher.class);
                dataParams.put("pcvNo", pettyCashVoucher.getPcvNo());
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", saccoName);
                reportParams.put("chequeNo", pettyCashVoucher.getRefNo());
                reportParams.put("bank", pettyCashVoucher.getBank().toString());
                reportParams.put("pcvDate", pettyCashVoucher.getPcvDate());
                reportParams.put("pcvNo", pettyCashVoucher.getPcvNo());
                new Config().getReport("Petty Cash Voucher", "masterfetch?type=pcvlines", dataParams, "pettycashvoucher.jasper", reportParams, user);
            }
            case "salesinvoice": {
                try {
                    SalesHeader invoice = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                    HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                    parameters2.put("saccoName", saccoName);
                    parameters2.put("companyAddress", Config.getShopAddress());
                    parameters2.put("invoiceNo", invoice.getDoc_no());
                    parameters2.put("invoiceDate", invoice.getSales_date());
                    parameters2.put("required", invoice.getSales_date());
                    if (eTIMSIntegration) {
                        parameters2.put("serialNo", invoice.getSerialNo());
                        parameters2.put("cu_invoiceNo", invoice.getCuInvoiceNo());
                        parameters2.put("internalData", invoice.getInternalData());
                        parameters2.put("receiptSignature", invoice.getReceiptSignature());
                        parameters2.put("qrCode", invoice.getQrCode());
                    }
                    parameters2.put("documentType", invoice.getDocType().toUpperCase());
                    parameters2.put("reference", invoice.getReference());
                    Customer customer = invoice.getCustomer();
                    parameters2.put("customerNo", customer.getCustomerNumber());
                    parameters2.put("paymentTerms", (int)customer.getCreditPeriod() + " Days From Invoice");
                    parameters2.put("customerPhone", customer.getCustomerPhone());
                    parameters2.put("customerEmail", customer.getCustomerEmail());
                    parameters2.put("customerName", customer.getCustomerName());
                    parameters2.put("amountInWords", new Config().amountInWords(invoice.getTotalAmount()));
                    parameters2.put("currentOutstandingBalance", customer.getLatestBalance(user));
                    String customerDetails = customer.getCustomerName().toUpperCase();
                    parameters2.put("customerDetails", customerDetails);
                    String shippingDetails = customer.getCustomerName().toUpperCase();
                    parameters2.put("shippingDetails", shippingDetails);
                    parameters2.put("customerVat", customer.getKraPin());
                    try {
                        parameters2.put("salesPerson", invoice.getSalesRep().getFullName());
                    }
                    catch (Exception u) {
                        parameters2.put("salesPerson", "");
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", invoice.getDoc_no());
                    params.put("docNo", invoice.getDoc_no());
                    params.put("docType", invoice.getDocument_type());
                    new Config().getReport("Customer Invoice", "masterfetch?type=salesline", params, "customerinvoice.jasper", parameters2, user);
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                break;
            }
            case "a4_receipt": {
                try {
                    SalesHeader invoice = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                    HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                    parameters2.put("saccoName", saccoName);
                    parameters2.put("companyAddress", Config.getShopAddress());
                    parameters2.put("invoiceNo", invoice.getDoc_no());
                    parameters2.put("invoiceDate", invoice.getSales_date());
                    parameters2.put("required", invoice.getSales_date());
                    if (eTIMSIntegration) {
                        parameters2.put("serialNo", invoice.getSerialNo());
                        parameters2.put("cu_invoiceNo", invoice.getCuInvoiceNo());
                        parameters2.put("internalData", invoice.getInternalData());
                        parameters2.put("receiptSignature", invoice.getReceiptSignature());
                        parameters2.put("qrCode", invoice.getQrCode());
                    }
                    parameters2.put("documentType", invoice.getDocType().toUpperCase());
                    parameters2.put("reference", invoice.getReference());
                    Customer customer = invoice.getCustomer();
                    parameters2.put("customerNo", customer.getCustomerNumber());
                    parameters2.put("paymentTerms", (int)customer.getCreditPeriod() + " Days From Invoice");
                    parameters2.put("customerPhone", customer.getCustomerPhone());
                    parameters2.put("customerEmail", customer.getCustomerEmail());
                    parameters2.put("customerName", customer.getCustomerName());
                    parameters2.put("amountInWords", new Config().amountInWords(invoice.getTotalAmount()));
                    parameters2.put("currentOutstandingBalance", customer.getLatestBalance(user));
                    String customerDetails = customer.getCustomerName().toUpperCase();
                    parameters2.put("customerDetails", customerDetails);
                    String shippingDetails = customer.getCustomerName().toUpperCase();
                    parameters2.put("shippingDetails", shippingDetails);
                    parameters2.put("customerVat", customer.getKraPin());
                    try {
                        parameters2.put("salesPerson", invoice.getSalesRep().getFullName());
                    }
                    catch (Exception u) {
                        parameters2.put("salesPerson", "");
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", invoice.getDoc_no());
                    params.put("docNo", invoice.getDoc_no());
                    params.put("docType", invoice.getDocument_type());
                    new Config().getReport("A4 Receipt", "masterfetch?type=salesline", params, "customerinvoice.jasper", parameters2, user);
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                break;
            }
            case "80mm_invoice": {
                try {
                    SalesHeader invoice = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                    HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                    parameters2.put("saccoName", saccoName);
                    parameters2.put("companyAddress", Config.getShopAddress());
                    parameters2.put("invoiceNo", invoice.getDoc_no());
                    parameters2.put("invoiceDate", invoice.getSales_date());
                    parameters2.put("required", invoice.getSales_date());
                    if (eTIMSIntegration) {
                        parameters2.put("serialNo", invoice.getSerialNo());
                        parameters2.put("cu_invoiceNo", invoice.getCuInvoiceNo());
                        parameters2.put("internalData", invoice.getInternalData());
                        parameters2.put("receiptSignature", invoice.getReceiptSignature());
                        parameters2.put("qrCode", invoice.getQrCode());
                    }
                    parameters2.put("documentType", invoice.getDocType().toUpperCase());
                    parameters2.put("reference", invoice.getReference());
                    Customer customer = invoice.getCustomer();
                    parameters2.put("customerNo", customer.getCustomerNumber());
                    parameters2.put("paymentTerms", (int)customer.getCreditPeriod() + " Days From Invoice");
                    parameters2.put("customerPhone", customer.getCustomerPhone());
                    parameters2.put("customerEmail", customer.getCustomerEmail());
                    parameters2.put("customerName", customer.getCustomerName());
                    parameters2.put("amountInWords", new Config().amountInWords(invoice.getTotalAmount()));
                    parameters2.put("currentOutstandingBalance", customer.getLatestBalance(user));
                    String customerDetails = customer.getCustomerName().toUpperCase();
                    parameters2.put("customerDetails", customerDetails);
                    String shippingDetails = customer.getCustomerName().toUpperCase();
                    parameters2.put("shippingDetails", shippingDetails);
                    parameters2.put("customerVat", customer.getKraPin());
                    try {
                        parameters2.put("salesPerson", invoice.getSalesRep().getFullName());
                    }
                    catch (Exception u) {
                        parameters2.put("salesPerson", "");
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", invoice.getDoc_no());
                    params.put("docNo", invoice.getDoc_no());
                    params.put("docType", invoice.getDocument_type());
                    new Config().getReport("Customer Invoice", "masterfetch?type=salesline", params, "80mm_customer_invoice.jasper", parameters2, user);
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                break;
            }
            case "deliverynote": {
                try {
                    SalesHeader invoice = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                    HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                    parameters2.put("saccoName", saccoName);
                    parameters2.put("invoiceNo", invoice.getDoc_no());
                    parameters2.put("invoiceDate", invoice.getSales_date());
                    parameters2.put("documentType", "Delivery Note");
                    Customer customer = invoice.getCustomer();
                    String customerDetails = customer.getCustomerName().toUpperCase();
                    parameters2.put("customerDetails", customerDetails);
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", invoice.getDoc_no());
                    params.put("docNo", invoice.getDoc_no());
                    params.put("docType", invoice.getDocument_type());
                    new Config().getReport("Delivery Note", "masterfetch?type=salesline", params, "delivery_note.jasper", parameters2, user);
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                break;
            }
            case "transfer_delivery_note": {
                try {
                    StockTransfer transfer = (StockTransfer)new Gson().fromJson(json, StockTransfer.class);
                    HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                    parameters2.put("saccoName", saccoName);
                    parameters2.put("invoiceNo", transfer.getCode());
                    parameters2.put("invoiceDate", transfer.getDateCreated());
                    parameters2.put("documentType", "Transfer Delivery Note");
                    String customerDetails = "Transfer From: " + transfer.getTransferFrom() + "\nTransfer To:" + transfer.getTransferTo();
                    parameters2.put("customerDetails", customerDetails);
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("transferCode", transfer.getCode());
                    new Config().getReport("Delivery Note", "masterfetch?type=stocktransferlines", params, "delivery_note.jasper", parameters2, user);
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                break;
            }
            case "proformaInvoice": {
                Object invoice = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", saccoName);
                parameters2.put("companyAddress", companyAddress);
                parameters2.put("invoiceNo", ((SalesHeader)invoice).getDoc_no());
                parameters2.put("invoiceDate", ((SalesHeader)invoice).getSales_date());
                Customer customer = ((SalesHeader)invoice).getCustomer();
                parameters2.put("customerPhone", customer.getCustomerPhone());
                parameters2.put("customerEmail", customer.getCustomerEmail());
                parameters2.put("customerName", customer.getCustomerName());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("invoiceNo", ((SalesHeader)invoice).getDoc_no());
                new Config().getReport("Customer Invoice", "masterfetch?type=customerinvoicelines", params, "customerinvoice.jasper", parameters2, user);
            }
            case "purchaseinvoice": {
                HashMap<String, Object> parameters2;
                Object invoice;
                try {
                    System.out.println(json);
                    invoice = (PurchaseHeader)new Gson().fromJson(json, PurchaseHeader.class);
                    parameters2 = new HashMap();
                    parameters2.put("saccoName", saccoName);
                    parameters2.put("companyAddress", Config.getShopAddress());
                    parameters2.put("invoiceNo", ((PurchaseHeader)invoice).getDocumentNo());
                    parameters2.put("invoiceDate", ((PurchaseHeader)invoice).getInvoiceDate());
                    parameters2.put("required", ((PurchaseHeader)invoice).getInvoiceDate());
                    parameters2.put("documentType", ((PurchaseHeader)invoice).getDocumentType().toUpperCase());
                    parameters2.put("location", ((PurchaseHeader)invoice).getLocation().getName());
                    parameters2.put("reference", "");
                    Vendor vendor = ((PurchaseHeader)invoice).getVendor();
                    parameters2.put("customerNo", vendor.getVendorNumber());
                    parameters2.put("paymentTerms", "0 Days From Invoice");
                    parameters2.put("customerPhone", vendor.getVendorPhone());
                    parameters2.put("customerEmail", vendor.getVendorEmail());
                    parameters2.put("customerName", vendor.getName());
                    String vendorDetails = vendor.getName().toUpperCase() + "\n";
                    try {
                        vendorDetails = vendorDetails + (vendor.getVendorAddress().isEmpty() ? "" : vendor.getVendorAddress());
                    }
                    catch (Exception params) {
                        // empty catch block
                    }
                    parameters2.put("customerDetails", vendorDetails);
                    String shippingDetails = vendor.getName().toUpperCase() + "\n" + vendor.getVendorAddress();
                    parameters2.put("shippingDetails", shippingDetails);
                    parameters2.put("customerVat", vendor.getKraPin());
                    parameters2.put("entryNo", ((PurchaseHeader)invoice).getEntryNo());
                    parameters2.put("lpoNo", ((PurchaseHeader)invoice).getLpoNo());
                    parameters2.put("extInvNo", ((PurchaseHeader)invoice).getExternalDocNo());
                    try {
                        parameters2.put("salesPerson", "");
                    }
                    catch (Exception u) {
                        parameters2.put("salesPerson", "");
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", ((PurchaseHeader)invoice).getDocumentNo());
                    params.put("docNo", ((PurchaseHeader)invoice).getDocumentNo());
                    params.put("docType", "Purchase Invoice");
                    new Config().getReport("Purchase Invoice", "masterfetch?type=vendorinvoicelines", params, "vendorinvoice.jasper", parameters2, user);
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                break;
            }
            case "lpo": {
                try {
                    PurchaseHeader invoice = (PurchaseHeader)new Gson().fromJson(json, PurchaseHeader.class);
                    HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                    parameters2.put("saccoName", saccoName);
                    parameters2.put("companyAddress", Config.getShopAddress());
                    parameters2.put("invoiceNo", invoice.getDocumentNo());
                    parameters2.put("invoiceDate", invoice.getInvoiceDate());
                    parameters2.put("required", invoice.getInvoiceDate());
                    parameters2.put("documentType", invoice.getDocumentType().toUpperCase());
                    parameters2.put("location", invoice.getLocation().getName());
                    parameters2.put("reference", "");
                    Vendor vendor = invoice.getVendor();
                    parameters2.put("customerNo", vendor.getVendorNumber());
                    parameters2.put("paymentTerms", "0 Days From Invoice");
                    parameters2.put("customerPhone", vendor.getVendorPhone());
                    parameters2.put("customerEmail", vendor.getVendorEmail());
                    parameters2.put("customerName", vendor.getName());
                    String vendorDetails = vendor.getName().toUpperCase() + "\n";
                    try {
                        vendorDetails = vendorDetails + (vendor.getVendorAddress().isEmpty() ? "" : vendor.getVendorAddress());
                    }
                    catch (Exception shippingDetails) {
                        // empty catch block
                    }
                    parameters2.put("customerDetails", vendorDetails);
                    String shippingDetails = vendor.getName().toUpperCase() + "\n" + vendor.getVendorAddress();
                    parameters2.put("shippingDetails", shippingDetails);
                    parameters2.put("customerVat", vendor.getKraPin());
                    parameters2.put("entryNo", invoice.getEntryNo());
                    parameters2.put("lpoNo", invoice.getLpoNo());
                    parameters2.put("extInvNo", invoice.getExternalDocNo());
                    try {
                        parameters2.put("salesPerson", "");
                    }
                    catch (Exception u) {
                        parameters2.put("salesPerson", "");
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("invoiceNo", invoice.getDocumentNo());
                    params.put("docNo", invoice.getDocumentNo());
                    params.put("docType", "Local Purchase Order");
                    new Config().getReport("Local Purchase Order", "masterfetch?type=vendorinvoicelines", params, "lpo.jasper", parameters2, user);
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                break;
            }
            case "staffloanstatement": {
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                StaffLoan loan = (StaffLoan)new Gson().fromJson(json, StaffLoan.class);
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("address", companyAddress);
                reportVariables.put("loanNo", loan.getId());
                reportVariables.put("balance", loan.getLoanBalanceString());
                reportVariables.put("principalAmount", loan.getAmountString());
                reportVariables.put("staffName", loan.getEmployee().getFullName());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("loanNo", loan.getId());
                new Config().getReport("Staff Loan Statement", "masterfetch?type=staffloanstatement", params, "staffloanstatement.jasper", reportVariables, user);
                return;
            }
            case "stock_request_form": {
                SalesHeader salesHeader = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                System.out.println(new Gson().toJson((Object)salesHeader));
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("reportName", "Stock Request");
                reportVariables.put("docNo", salesHeader.getDoc_no());
                reportVariables.put("docType", salesHeader.getDocument_type());
                reportVariables.put("docDate", salesHeader.getSales_date());
                reportVariables.put("vsm", "");
                reportVariables.put("approvedBy", user.getFullName());
                LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                params2.put("docNo", salesHeader.getDoc_no());
                params2.put("docType", salesHeader.getDocument_type());
                new Config().getReport("Stock Request", "masterfetch?type=salesline", params2, "stockrequest.jasper", reportVariables, user);
                return;
            }
            case "end_of_day": {
                SalesHeader salesHeader = (SalesHeader)new Gson().fromJson(json, SalesHeader.class);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("reportName", "END OF DAY REPORT");
                reportVariables.put("docNo", salesHeader.getDoc_no());
                reportVariables.put("docType", salesHeader.getDocument_type());
                reportVariables.put("docDate", salesHeader.getSales_date());
                try {
                    reportVariables.put("vsm", salesHeader.getCustomer().getCustomerName());
                }
                catch (Exception params2) {
                    // empty catch block
                }
                reportVariables.put("approvedBy", user.getFullName());
                LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                params2.put("docNo", salesHeader.getDoc_no());
                params2.put("docType", salesHeader.getDocument_type());
                new Config().getReport("End of Day Request", "masterfetch?type=salesline", params2, "end_of_day_request.jasper", reportVariables, user);
                return;
            }
            case "salaryadvancestatement": {
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                SalaryAdvance loan = (SalaryAdvance)new Gson().fromJson(json, SalaryAdvance.class);
                reportVariables.put("saccoName", saccoName);
                reportVariables.put("address", companyAddress);
                reportVariables.put("loanNo", loan.getId());
                reportVariables.put("balance", loan.getBalanceString());
                reportVariables.put("principalAmount", loan.getAmountString());
                reportVariables.put("staffName", loan.getEmployee().getFullName());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("loanNo", loan.getId());
                new Config().getReport("Staff Loan Statement", "masterfetch?type=salaryadvancestatement", params, "staffloanstatement.jasper", reportVariables, user);
                return;
            }
            case "propertylandlordstatement": {
                LinkedHashMap reportVariables = new LinkedHashMap();
                Property property = (Property)new Gson().fromJson(json, Property.class);
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
                    Scene editMember = new Scene((Parent)itemPane);
                    final Stage stage = new Stage();
                    editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent t) {
                            KeyCode key = t.getCode();
                            if (key == KeyCode.ESCAPE) {
                                stage.close();
                            }
                        }
                    });
                    stage.setScene(editMember);
                    PNLFilter controller = (PNLFilter)loader.getController();
                    controller.setUser(user);
                    controller.setProperty(property);
                    controller.setReportName("propertylandlordstatement");
                    stage.setTitle("Landlord Statement Filter");
                    stage.setResizable(false);
                    stage.show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            default: {
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateReport(String reportName, User user) {
        switch (reportName = reportName.toLowerCase()) {
            case "allcustomers": {
                this.showDatesFilter(user, reportName, "All Customers Filter");
                return;
            }
            case "rep_sales_summary": {
                this.showDatesFilter(user, reportName, "Reps Sales Summary");
                return;
            }
            case "sales_summary": {
                this.showDatesFilter(user, reportName, "Sales Summary Filter");
                return;
            }
            case "all_customers_profitability": {
                this.showDatesFilter(user, reportName, "All Customers Profitability");
                return;
            }
            case "commissions_report": {
                this.showDatesFilter(user, reportName, "Commissions Report Filter");
                return;
            }
            case "bank_discrepancy": {
                this.showDatesFilter(user, reportName, "Bank Discrepancy");
                return;
            }
            case "sales_person_report": {
                this.showDatesFilter(user, reportName, "Sales Person Summary Filter");
                return;
            }
            case "region_sales_report": {
                this.loadItemsFilter(reportName, "Region Sales Report", user);
                return;
            }
            case "region_sales_per_product": {
                this.loadItemsFilter(reportName, "Region Sales per Product", user);
                return;
            }
            case "purchase_summary": {
                this.showDatesFilter(user, reportName, "Purchase Summary Filter");
                return;
            }
            case "dms_sales": {
                this.showDatesFilter(user, reportName, "DMS Sales Filter");
                return;
            }
            case "distributor_sales_summary": {
                this.showDatesFilter(user, reportName, "Distributor Sales Filter");
                return;
            }
            case "stock_report": {
                this.showDatesFilter(user, reportName, "Stock Report Filter");
                return;
            }
            case "accounts_report": {
                this.showDatesFilter(user, reportName, "Accounts Report Filter");
                return;
            }
            case "detailed_sales": {
                this.showDatesFilter(user, reportName, "Detailed Sales Filter");
                return;
            }
            case "detailed_payments": {
                this.showDatesFilter(user, reportName, "Detailed Payments Filter");
                return;
            }
            case "payments_summary": {
                this.showDatesFilter(user, reportName, "Payments Summary Filter");
                return;
            }
            case "stockanalysis": {
                this.loadItemsFilter(reportName, "Stock Analysis Filter", user);
                return;
            }
            case "masterroll": {
                this.loadMasterRollReport(reportName, "MasterRoll Filter", user);
                return;
            }
            case "bank_export": {
                this.loadMasterRollReport(reportName, "Bank Export Filter", user);
                return;
            }
            case "paye_export": {
                this.loadMasterRollReport(reportName, "PAYE Export Filter", user);
                return;
            }
            case "nhif_export": {
                this.loadMasterRollReport(reportName, "NHIF Export Filter", user);
                return;
            }
            case "nssf_export": {
                this.loadMasterRollReport(reportName, "NSSF Export Filter", user);
                return;
            }
            case "allemployees": {
                try {
                    LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                    reportVariables.put("saccoName", saccoName);
                    new Config().getReport("All Employees List", "masterfetch?type=employees", new LinkedHashMap<String, Object>(), "allemployees.jasper", reportVariables, user);
                    return;
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
                return;
            }
            case "allvendors": {
                this.showDatesFilter(user, reportName, "All Vendors Filter");
                return;
            }
            case "allassets": {
                this.loadItemsFilter(reportName, "All Assets", user);
                return;
            }
            case "stockperlocation": {
                this.loadItemsFilter(reportName, "Stock Per Location", user);
                return;
            }
            case "sales_per_sales_rep": {
                this.loadItemsFilter(reportName, "Sales Per Sales Rep", user);
                return;
            }
            case "sales_per_posting_group": {
                this.loadItemsFilter(reportName, "Sales Per Posting Group", user);
                return;
            }
            case "route_profitability": {
                this.loadItemsFilter(reportName, "Route Profitability", user);
                return;
            }
            case "region_profitability": {
                this.loadItemsFilter(reportName, "Region Profitability", user);
                return;
            }
            case "fuel_consumption": {
                this.loadItemsFilter(reportName, "Fuel, Repairs & Maintenance", user);
                return;
            }
            case "complete_empty_movement": {
                this.loadItemsFilter(reportName, "Complete Empty Movement", user);
                return;
            }
            case "countsheet": {
                this.loadItemsFilter(reportName, "Count Sheet", user);
                return;
            }
            case "price_list": {
                this.loadItemsFilter(reportName, "Price List", user);
                return;
            }
            case "product_margins": {
                this.loadItemsFilter(reportName, "Product Margins", user);
                return;
            }
            case "allcustomerinvoices": {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
                    Scene editMember = new Scene((Parent)itemPane);
                    final Stage stage = new Stage();
                    editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent t) {
                            KeyCode key = t.getCode();
                            if (key == KeyCode.ESCAPE) {
                                stage.close();
                            }
                        }
                    });
                    stage.setScene(editMember);
                    PNLFilter controller = (PNLFilter)loader.getController();
                    controller.setUser(user);
                    controller.setReportName("customerinvoices");
                    stage.setTitle("Customer Invoices Filter");
                    stage.setResizable(false);
                    stage.show();
                    return;
                }
                catch (Exception loader) {
                    // empty catch block
                }
                return;
            }
            case "customerbalances": {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
                    Scene editMember = new Scene((Parent)itemPane);
                    final Stage stage = new Stage();
                    editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent t) {
                            KeyCode key = t.getCode();
                            if (key == KeyCode.ESCAPE) {
                                stage.close();
                            }
                        }
                    });
                    stage.setScene(editMember);
                    PNLFilter controller = (PNLFilter)loader.getController();
                    controller.setUser(user);
                    controller.setReportName("customerbalances");
                    stage.setTitle("Customer Balances Filter");
                    stage.setResizable(false);
                    stage.show();
                    return;
                }
                catch (Exception loader) {
                    // empty catch block
                }
                return;
            }
            case "vendorbalances": {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
                    Scene editMember = new Scene((Parent)itemPane);
                    final Stage stage = new Stage();
                    editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent t) {
                            KeyCode key = t.getCode();
                            if (key == KeyCode.ESCAPE) {
                                stage.close();
                            }
                        }
                    });
                    stage.setScene(editMember);
                    PNLFilter controller = (PNLFilter)loader.getController();
                    controller.setUser(user);
                    controller.setReportName("vendorbalances");
                    stage.setTitle("Vendor Balances Filter");
                    stage.setResizable(false);
                    stage.show();
                    return;
                }
                catch (Exception loader) {
                    // empty catch block
                }
                return;
            }
            case "importtransactions": {
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Select Excel to Import Transactions from");
                chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx"})});
                try {
                    File file = chooser.showOpenDialog((Window)new Stage());
                    boolean newVoucher = false;
                    if (file == null) return;
                    try {
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        XSSFSheet ws = wb.getSheetAt(0);
                        int limit = 0;
                        limit = ws.getPhysicalNumberOfRows();
                        for (int a = 1; a < limit; ++a) {
                            String string;
                            LinkedHashMap<String, Object> params3;
                            Cell myCell;
                            XSSFRow myRow = ws.getRow(a);
                            System.out.println("Running Line " + a + " of " + limit);
                            String tDate = "";
                            String clientName = "";
                            double amount = 0.0;
                            double currentAccount = 0.0;
                            double annualSubscription = 0.0;
                            double trainingIncome = 0.0;
                            double donations = 0.0;
                            double ushirikaCouncil = 0.0;
                            double magazineIncome = 0.0;
                            try {
                                myCell = myRow.getCell(0);
                                Date mDate = myCell.getDateCellValue();
                                SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd");
                                tDate = sm.format(mDate);
                            }
                            catch (Exception t) {
                                tDate = "";
                            }
                            try {
                                myCell = myRow.getCell(1);
                                clientName = myCell.toString().trim();
                            }
                            catch (Exception t) {
                                clientName = "";
                            }
                            try {
                                myCell = myRow.getCell(2);
                                amount = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                amount = 0.0;
                            }
                            try {
                                myCell = myRow.getCell(3);
                                currentAccount = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                currentAccount = 0.0;
                            }
                            try {
                                myCell = myRow.getCell(4);
                                annualSubscription = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                annualSubscription = 0.0;
                            }
                            try {
                                myCell = myRow.getCell(5);
                                trainingIncome = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                trainingIncome = 0.0;
                            }
                            try {
                                myCell = myRow.getCell(6);
                                donations = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                donations = 0.0;
                            }
                            try {
                                myCell = myRow.getCell(7);
                                ushirikaCouncil = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                ushirikaCouncil = 0.0;
                            }
                            try {
                                myCell = myRow.getCell(10);
                                magazineIncome = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                magazineIncome = 0.0;
                            }
                            String tAccount = "";
                            int tItemNo = 0;
                            if (tAccount.trim().equalsIgnoreCase("Annual Subscription Fee")) {
                                tItemNo = 1;
                            } else if (tAccount.trim().equalsIgnoreCase("Leaders Forum Income")) {
                                tItemNo = 2;
                            } else if (tAccount.trim().equalsIgnoreCase("Magazine Income")) {
                                tItemNo = 3;
                            } else if (tAccount.trim().equalsIgnoreCase("Training Income")) {
                                tItemNo = 4;
                            }
                            double lineTotal = annualSubscription + trainingIncome + donations + ushirikaCouncil + magazineIncome;
                            System.out.println("Line total is " + lineTotal);
                            if (!(lineTotal > 0.0)) continue;
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("accountNumber", "");
                            params.put("accountName", clientName);
                            String response = Config.loadDataFromPhp("mastercreate?type=importcustomer", params, user);
                            System.out.println(response);
                            Gson gson = new Gson();
                            JsonResponses jr = (JsonResponses)gson.fromJson(response, JsonResponses.class);
                            String customerNo = jr.getOverLoad1();
                            NumberSeries nb = new NumberSeries(7, user);
                            String tInvoiceNo = nb.getNextNumber();
                            LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                            params2.put("invoiceNo", tInvoiceNo);
                            params2.put("customer", customerNo);
                            params2.put("invoiceDate", tDate);
                            params2.put("shopLocationCode", "");
                            params2.put("region", "");
                            params2.put("salesRep", "");
                            params2.put("document_type", "sales_invoice");
                            String response2 = Config.loadDataFromPhp("mastercreate?type=customerinvoice", params2, user);
                            System.out.println(response2);
                            JsonResponses jr1 = (JsonResponses)gson.fromJson(response2, JsonResponses.class);
                            if (!jr1.isStatus()) continue;
                            nb.updateLastUsed(tInvoiceNo);
                            if (annualSubscription > 0.0) {
                                params3 = new LinkedHashMap<String, Object>();
                                params3.put("invoiceNo", tInvoiceNo);
                                params3.put("itemType", "Charge Items");
                                params3.put("itemNo", "1");
                                params3.put("description", "Annual Subscription Fee");
                                params3.put("unitPrice", annualSubscription);
                                params3.put("quantity", 1);
                                params3.put("uomRelationshipCode", "");
                                string = Config.loadDataFromPhp("mastercreate?type=customerinvoiceline", params3, user);
                            }
                            if (trainingIncome > 0.0) {
                                params3 = new LinkedHashMap();
                                params3.put("invoiceNo", tInvoiceNo);
                                params3.put("itemType", "Charge Items");
                                params3.put("itemNo", "4");
                                params3.put("description", "Training Income");
                                params3.put("unitPrice", trainingIncome);
                                params3.put("quantity", 1);
                                params3.put("uomRelationshipCode", "");
                                string = Config.loadDataFromPhp("mastercreate?type=customerinvoiceline", params3, user);
                            }
                            if (donations > 0.0) {
                                params3 = new LinkedHashMap();
                                params3.put("invoiceNo", tInvoiceNo);
                                params3.put("itemType", "Charge Items");
                                params3.put("itemNo", "8");
                                params3.put("description", "Donations");
                                params3.put("unitPrice", donations);
                                params3.put("quantity", 1);
                                params3.put("uomRelationshipCode", "");
                                string = Config.loadDataFromPhp("mastercreate?type=customerinvoiceline", params3, user);
                            }
                            if (ushirikaCouncil > 0.0) {
                                params3 = new LinkedHashMap();
                                params3.put("invoiceNo", tInvoiceNo);
                                params3.put("itemType", "Charge Items");
                                params3.put("itemNo", "9");
                                params3.put("description", "Ushirika Day");
                                params3.put("unitPrice", ushirikaCouncil);
                                params3.put("quantity", 1);
                                params3.put("uomRelationshipCode", "");
                                string = Config.loadDataFromPhp("mastercreate?type=customerinvoiceline", params3, user);
                            }
                            if (magazineIncome > 0.0) {
                                params3 = new LinkedHashMap();
                                params3.put("invoiceNo", tInvoiceNo);
                                params3.put("itemType", "Charge Items");
                                params3.put("itemNo", "3");
                                params3.put("description", "Magazine Income");
                                params3.put("unitPrice", magazineIncome);
                                params3.put("quantity", 1);
                                params3.put("uomRelationshipCode", "");
                                string = Config.loadDataFromPhp("mastercreate?type=customerinvoiceline", params3, user);
                            }
                            LinkedHashMap<String, Object> params4 = new LinkedHashMap<String, Object>();
                            params4.put("invoiceNo", tInvoiceNo);
                            params4.put("docNo", tInvoiceNo);
                            String response20 = Config.loadDataFromPhp("masterpost?type=customerinvoice", params4, user);
                            System.out.println(response20);
                            JsonResponses jr3 = (JsonResponses)gson.fromJson(response20, JsonResponses.class);
                            if (!jr3.isStatus()) continue;
                            NumberSeries nb4 = new NumberSeries(8, user);
                            String receiptNo = nb4.getNextNumber();
                            LinkedHashMap<String, Object> params5 = new LinkedHashMap<String, Object>();
                            params5.put("receiptNo", receiptNo);
                            params5.put("customerNo", customerNo);
                            params5.put("bankCode", "1");
                            params5.put("paymentMethod", "1");
                            params5.put("paymentRef", "");
                            params5.put("paymentDate", tDate);
                            String response10 = Config.loadDataFromPhp("mastercreate?type=customerreceipt", params5, user);
                            JsonResponses jr10 = (JsonResponses)new Gson().fromJson(response10, JsonResponses.class);
                            if (!jr10.isStatus()) continue;
                            nb4.updateLastUsed(receiptNo);
                            LinkedHashMap<String, Object> params6 = new LinkedHashMap<String, Object>();
                            params6.put("receiptNo", receiptNo);
                            params6.put("paymentType", "1");
                            params6.put("invoiceNo", tInvoiceNo);
                            params6.put("description", "Payment");
                            params6.put("amount", lineTotal);
                            String response11 = Config.loadDataFromPhp("mastercreate?type=customerreceiptline", params6, user);
                            System.out.println(response);
                            JsonResponses jr11 = (JsonResponses)new Gson().fromJson(response11, JsonResponses.class);
                            if (!jr11.isStatus()) continue;
                            LinkedHashMap<String, Object> params12 = new LinkedHashMap<String, Object>();
                            params12.put("receiptNo", receiptNo);
                            String response12 = Config.loadDataFromPhp("masterpost?type=customerreceipt", params12, user);
                            System.out.println(response12);
                        }
                        return;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
                catch (Exception p) {
                    p.printStackTrace();
                }
                return;
            }
            case "importquickbooks": {
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Select Excel to Import Transactions from");
                chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx"})});
                try {
                    File file = chooser.showOpenDialog((Window)new Stage());
                    boolean newVoucher = false;
                    if (file == null) return;
                    try {
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        XSSFSheet ws = wb.getSheetAt(0);
                        int limit = 0;
                        limit = ws.getPhysicalNumberOfRows();
                        String globalDate = "";
                        String globalTransNo = "";
                        String globalType = "";
                        for (int a = 1; a < limit; ++a) {
                            Cell myCell;
                            XSSFRow myRow = ws.getRow(a);
                            System.out.println("Running Line " + a + " of " + limit);
                            String transNo = "";
                            String type = "";
                            String date = "";
                            String number = "";
                            String name = "";
                            String memo = "";
                            String account = "";
                            String tClass = "";
                            double amount = 0.0;
                            try {
                                myCell = myRow.getCell(0);
                                transNo = myCell.toString().trim();
                                if (transNo.length() <= 0) {
                                    throw new Exception();
                                }
                                globalTransNo = transNo = transNo.replace(".0", "");
                            }
                            catch (Exception t) {
                                transNo = globalTransNo;
                            }
                            try {
                                myCell = myRow.getCell(1);
                                type = myCell.toString().trim();
                                if (type.length() <= 0) {
                                    throw new Exception();
                                }
                                globalType = type;
                            }
                            catch (Exception t) {
                                type = globalType;
                            }
                            try {
                                myCell = myRow.getCell(2);
                                Date mDate = myCell.getDateCellValue();
                                SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd");
                                globalDate = date = sm.format(mDate);
                            }
                            catch (Exception t) {
                                date = globalDate;
                            }
                            try {
                                myCell = myRow.getCell(3);
                                number = myCell.toString();
                            }
                            catch (Exception t) {
                                number = "";
                            }
                            try {
                                myCell = myRow.getCell(4);
                                name = myCell.toString();
                            }
                            catch (Exception t) {
                                name = "";
                            }
                            try {
                                myCell = myRow.getCell(5);
                                memo = myCell.toString();
                            }
                            catch (Exception t) {
                                memo = "";
                            }
                            try {
                                myCell = myRow.getCell(6);
                                account = myCell.toString();
                            }
                            catch (Exception t) {
                                account = "";
                            }
                            try {
                                myCell = myRow.getCell(7);
                                tClass = myCell.toString();
                            }
                            catch (Exception t) {
                                tClass = "";
                            }
                            try {
                                myCell = myRow.getCell(8);
                                amount = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                amount = 0.0;
                            }
                            System.out.println("Trans No: " + transNo + " Trans Type: " + type + " Date: " + date + " Number: " + number + " Name: " + name + " Memo: " + memo + " Account: " + account + " Class: " + tClass + " Amount " + amount);
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("transNo", transNo);
                            params.put("type", type);
                            params.put("date", date);
                            params.put("number", number);
                            params.put("name", name);
                            params.put("memo", memo);
                            params.put("account", account);
                            params.put("tClass", tClass);
                            params.put("amount", amount);
                            String response = Config.loadDataFromPhp("mastercreate?type=qbledger", params, user);
                            System.out.println(response);
                        }
                        return;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
                catch (Exception p) {
                    p.printStackTrace();
                }
                return;
            }
            case "importexpenses": {
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Select Excel to Import Expenses from");
                chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx"})});
                try {
                    File file = chooser.showOpenDialog((Window)new Stage());
                    boolean newVoucher = false;
                    if (file == null) return;
                    try {
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        XSSFSheet ws = wb.getSheetAt(0);
                        int limit = ws.getPhysicalNumberOfRows();
                        ObservableList allLines = FXCollections.observableArrayList();
                        allLines.add((Object)"EXP036");
                        allLines.add((Object)"EXP041");
                        allLines.add((Object)"SAL008");
                        allLines.add((Object)"EXP017");
                        allLines.add((Object)"EXP023");
                        allLines.add((Object)"SAL008");
                        allLines.add((Object)"SAL008");
                        allLines.add((Object)"EXP036");
                        allLines.add((Object)"EXP018");
                        allLines.add((Object)"EXP030");
                        allLines.add((Object)"EXP028");
                        allLines.add((Object)"EXP035");
                        allLines.add((Object)"FA001");
                        allLines.add((Object)"EXP042");
                        allLines.add((Object)"EXP029");
                        allLines.add((Object)"EXP024");
                        allLines.add((Object)"EXP020");
                        allLines.add((Object)"EXP042");
                        allLines.add((Object)"EXP043");
                        allLines.add((Object)"EXP011");
                        allLines.add((Object)"EXP026");
                        allLines.add((Object)"EXP039");
                        allLines.add((Object)"EXP019");
                        allLines.add((Object)"EXP034");
                        allLines.add((Object)"EXP031");
                        allLines.add((Object)"EXP003");
                        allLines.add((Object)"EXP046");
                        allLines.add((Object)"EXP028");
                        allLines.add((Object)"EXP030");
                        allLines.add((Object)"EXP013");
                        allLines.add((Object)"EXP016");
                        allLines.add((Object)"EXP036");
                        allLines.add((Object)"EXP036");
                        allLines.add((Object)"EXP029");
                        allLines.add((Object)"EXP036");
                        allLines.add((Object)"EXP025");
                        allLines.add((Object)"EXP045");
                        allLines.add((Object)"EXP047");
                        allLines.add((Object)"EXP048");
                        allLines.add((Object)"EXP024");
                        allLines.add((Object)"EXP049");
                        allLines.add((Object)"EXP049");
                        allLines.add((Object)"EXP035");
                        allLines.add((Object)"EXP032");
                        for (int a = 1; a < limit; ++a) {
                            Cell myCell;
                            XSSFRow myRow = ws.getRow(a);
                            System.out.println("Running Line " + a + " of " + limit);
                            String tDate = "";
                            String particulars = "";
                            String chequeNo = "";
                            double amount = 0.0;
                            try {
                                String finalDate;
                                Cell myCell2 = myRow.getCell(0);
                                String[] dateDetails = myCell2.toString().split("/");
                                tDate = finalDate = dateDetails[2] + "-" + dateDetails[1] + "-" + dateDetails[0];
                            }
                            catch (Exception t) {
                                tDate = "";
                            }
                            NumberSeries ns = new NumberSeries(45, user);
                            String tJournalNo = ns.getNextNumber();
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("journalNo", tJournalNo);
                            params.put("date", tDate);
                            String response = Config.loadDataFromPhp("mastercreate?type=journal", params, user);
                            Gson gson = new Gson();
                            JsonResponses jr = (JsonResponses)gson.fromJson(response, JsonResponses.class);
                            if (jr.isStatus()) {
                                ns.updateLastUsed(tJournalNo);
                            }
                            try {
                                myCell = myRow.getCell(1);
                                particulars = myCell.toString().trim();
                            }
                            catch (Exception t) {
                                particulars = "";
                            }
                            try {
                                myCell = myRow.getCell(2);
                                chequeNo = myCell.toString().trim();
                            }
                            catch (Exception t) {
                                chequeNo = "";
                            }
                            try {
                                myCell = myRow.getCell(2);
                                amount = myCell.getNumericCellValue();
                            }
                            catch (Exception t) {
                                amount = 0.0;
                            }
                            double lineTotal = 0.0;
                            for (int b = 0; b < 48; ++b) {
                                try {
                                    Cell myCell3 = myRow.getCell(b);
                                    amount = myCell3.getNumericCellValue();
                                    String accountNo = (String)allLines.get(b - 5);
                                    LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                                    params2.put("journalNo", tJournalNo);
                                    params2.put("accountType", "glaccount");
                                    params2.put("accountNo", accountNo);
                                    params2.put("transactionType", "");
                                    params2.put("externalDoc", chequeNo);
                                    params2.put("description", particulars);
                                    params2.put("amount", amount);
                                    if (amount > 0.0) {
                                        String string = Config.loadDataFromPhp("mastercreate?type=journalline", params2, user);
                                    }
                                }
                                catch (Exception t) {
                                    amount = 0.0;
                                }
                                lineTotal += amount;
                            }
                            LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                            params2.put("journalNo", tJournalNo);
                            params2.put("accountType", "bank");
                            params2.put("accountNo", "1");
                            params2.put("transactionType", "");
                            params2.put("externalDoc", chequeNo);
                            params2.put("description", particulars);
                            params2.put("amount", lineTotal * -1.0);
                            String response2 = Config.loadDataFromPhp("mastercreate?type=journalline", params2, user);
                            LinkedHashMap<String, Object> params3 = new LinkedHashMap<String, Object>();
                            params3.put("journalNo", tJournalNo);
                            String response4 = Config.loadDataFromPhp("masterpost?type=journal", params3, user);
                            System.out.println(response4);
                        }
                        return;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
                catch (Exception p) {
                    p.printStackTrace();
                }
                return;
            }
            case "salesreport": {
                this.showDatesFilter(user, reportName, "Sales Report Filter");
                return;
            }
        }
    }

    public static String loadDataFromPhp(String myUrl, Map<String, Object> params, User user) {
        try {
            String string = user.getUserName();
        }
        catch (Exception t) {
            t.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Undefined User");
            alert.setHeaderText("Unable to identify the user. The system will close");
            alert.showAndWait();
        }
        long startTime = Config.getCurrentSystemTime();
        try {
            URL url = new URL(Config.getURL() + myUrl);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.setDoOutput(true);
            conn.setRequestProperty("username", user.getUserName());
            conn.setRequestProperty("password", user.getPassword());
            conn.setRequestProperty("versionNo", versionNo + "");
            conn.getOutputStream().write(postDataBytes);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String readLine = "";
            StringBuffer response = new StringBuffer();
            while ((readLine = in.readLine()) != null) {
                response.append(readLine);
            }
            String response2 = response.toString();
            long endTime = Config.getCurrentSystemTime();
            long timeTaken = endTime - startTime;
            System.out.println("Time Taken for " + myUrl + ": " + timeTaken);
            return response2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getDefaultButtonStyles() {
        String style = "   .button{\n    -fx-font-family:Monospaced;\n}\n.button:hover{\n    -fx-background-color:  #00897b;\n    -fx-text-fill:#ffffff;\n    -fx-font-weight:bold;\n}";
        return style;
    }

    public static FontAwesomeIconView getCheckIcon() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.CHECK);
        icon.setStyle("-fx-fill: #4CAF50;");
        icon.setSize("24.0");
        return icon;
    }

    public static FontAwesomeIconView getBanIcon() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("24.0");
        return icon;
    }

    public static FontAwesomeIconView getEditIcon() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.PENCIL);
        icon.setStyle("-fx-fill: #4CAF50;");
        icon.setSize("15.0");
        return icon;
    }

    public static FontAwesomeIconView getTimesIcon() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("24.0");
        return icon;
    }

    public static FontAwesomeIconView getPDFIcon() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.FILE_PDF_ALT);
        icon.setStyle("-fx-fill: #ab1a23;");
        icon.setSize("24.0");
        return icon;
    }

    public static FontAwesomeIconView getDeleteIcon() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("15.0");
        return icon;
    }

    public static ProgressIndicator getLoader() {
        ProgressIndicator loader = new ProgressIndicator();
        loader.setPrefWidth(15.0);
        loader.setPrefHeight(15.0);
        return loader;
    }

    public ProgressIndicator getLoader2() {
        ProgressIndicator loader = new ProgressIndicator();
        loader.setPrefWidth(15.0);
        loader.setPrefHeight(15.0);
        return loader;
    }

    public void getReport(String reportName, String dataUrl, Map<String, Object> dataVariables, String reportUrl, Map<String, Object> reportVariables, User user) {
        System.out.println(reportUrl);
        try {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/reportloader.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 600.0, 72.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ReportController controller = (ReportController)loader.getController();
                stage.setTitle("Loading " + reportName + " Report");
                stage.setResizable(false);
                controller.getReport(reportName, dataUrl, dataVariables, reportUrl, reportVariables, user);
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your load report screen. Please contact support");
                alert.showAndWait();
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
    }

    public void saveReportAsExcel(String reportName, String dataUrl, Map<String, Object> dataVariables, String reportUrl, Map<String, Object> reportVariables, User user) {
        try {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/reportloader.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 600.0, 72.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ReportController controller = (ReportController)loader.getController();
                stage.setTitle("Loading " + reportName + " Report");
                stage.setResizable(false);
                controller.saveReportAsExcel(reportName, dataUrl, dataVariables, reportUrl, reportVariables, user);
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your load report screen. Please contact support");
                alert.showAndWait();
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
    }

    public void saveReportAsPDF(String reportName, String dataUrl, Map<String, Object> dataVariables, String reportUrl, Map<String, Object> reportVariables, User user, String fileName) {
        try {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/reportloader.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 600.0, 72.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ReportController controller = (ReportController)loader.getController();
                stage.setTitle("Loading " + reportName + " Report");
                stage.setResizable(false);
                controller.saveReportAsPDF(reportName, dataUrl, dataVariables, reportUrl, reportVariables, user, fileName);
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your load report screen. Please contact support");
                alert.showAndWait();
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
    }

    public void saveJsonReportAsPDF(String reportName, String json, String reportUrl, Map<String, Object> reportVariables, User user, String fileName) {
        try {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/reportloader.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 600.0, 72.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ReportController controller = (ReportController)loader.getController();
                stage.setTitle("Loading " + reportName + " Report");
                stage.setResizable(false);
                controller.saveJsonReportAsPDF(reportName, json, reportUrl, reportVariables, user, fileName);
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your load report screen. Please contact support");
                alert.showAndWait();
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
    }

    public void getReportWithJson(String reportName, String json, String reportUrl, Map<String, Object> reportVariables) {
        try {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/reportloader.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 600.0, 72.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ReportController controller = (ReportController)loader.getController();
                stage.setTitle("Loading " + reportName + " Report");
                stage.setResizable(false);
                controller.getReportWithJson(reportName, json, reportUrl, reportVariables);
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your load report screen. Please contact support");
                alert.showAndWait();
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
    }

    public void printReport(String reportName, String dataUrl, Map<String, Object> dataVariables, String reportUrl, Map<String, Object> reportVariables, User user) {
        try {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/reportloader.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 600.0, 72.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ReportController controller = (ReportController)loader.getController();
                stage.setTitle("Loading " + reportName + " Report");
                stage.setResizable(false);
                controller.printReport(reportName, dataUrl, dataVariables, reportUrl, reportVariables, user);
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your load report screen. Please contact support");
                alert.showAndWait();
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
    }

    public void printReportWithJson(String reportName, String json, String reportUrl, Map<String, Object> reportVariables) {
        try {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/reportloader.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 600.0, 72.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ReportController controller = (ReportController)loader.getController();
                stage.setTitle("Loading " + reportName + " Report");
                stage.setResizable(false);
                controller.printReportWithJson(reportName, json, reportUrl, reportVariables);
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your load report screen. Please contact support");
                alert.showAndWait();
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
    }

    public static LocalDate getCurrentLocaldate() {
        LocalDate localDate = LocalDate.now();
        return localDate;
    }

    public NotificationPane setUpNotificationPane(NotificationPane notificationPane, Node holder) {
        notificationPane.setContent(holder);
        notificationPane.showFromTopProperty();
        notificationPane.setCloseButtonVisible(true);
        notificationPane.getStyleClass().add((Object)"dark");
        return notificationPane;
    }

    public TextField setDoubleTextField(TextField textField) {
        textField.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[-0123456789.]")) {
                    event.consume();
                }
            }
        });
        return textField;
    }

    public static String localDateToString(LocalDate date) {
        return date.toString();
    }

    public static LocalDate stringToLocalDate(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-d");
        LocalDate localDate = LocalDate.parse(date, formatter);
        return localDate;
    }

    public static String excelDateToDate(String excelDate) {
        String myDate = excelDate;
        myDate = myDate.replace("Jan", "01");
        myDate = myDate.replace("Feb", "02");
        myDate = myDate.replace("Mar", "03");
        myDate = myDate.replace("Apr", "04");
        myDate = myDate.replace("May", "05");
        myDate = myDate.replace("Jun", "06");
        myDate = myDate.replace("Jul", "07");
        myDate = myDate.replace("Aug", "08");
        myDate = myDate.replace("Sep", "09");
        myDate = myDate.replace("Oct", "10");
        myDate = myDate.replace("Nov", "11");
        myDate = myDate.replace("Dec", "12");
        String[] myDateInfo = myDate.split("-");
        String day = myDateInfo[0];
        String month = myDateInfo[1];
        String year = myDateInfo[2];
        return year + "-" + month + "-" + day;
    }

    public static boolean showConfirmDialog(String title, String headerText, String contentText) {
        try {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle(title);
            alert.setHeaderText(headerText);
            alert.setContentText(contentText);
            Optional result = alert.showAndWait();
            return result.get() == ButtonType.OK;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getObjectFromSelection(String type, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/accountselection.fxml").openStream());
            AccountSelectionController controller = (AccountSelectionController)loader.getController();
            controller.setUser(user);
            controller.setType(type);
            Scene addItemScene = new Scene((Parent)itemPane);
            Stage memberSelectionStage = new Stage();
            memberSelectionStage.setScene(addItemScene);
            memberSelectionStage.setTitle("Account Selection");
            memberSelectionStage.setResizable(false);
            try {
                memberSelectionStage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            memberSelectionStage.showAndWait();
            return controller.getObject();
        }
        catch (Exception p) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your object selection screen. Please contact support");
            p.printStackTrace();
            alert.showAndWait();
            return "";
        }
    }

    public String getObjectFromSelection(String type, String options, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/accountselection.fxml").openStream());
            AccountSelectionController controller = (AccountSelectionController)loader.getController();
            controller.setOptions(options);
            controller.setUser(user);
            controller.setType(type);
            Scene selectionScene = new Scene((Parent)itemPane);
            final Stage memberSelectionStage = new Stage();
            selectionScene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        memberSelectionStage.close();
                    }
                }
            });
            memberSelectionStage.setScene(selectionScene);
            memberSelectionStage.setTitle("Account Selection");
            memberSelectionStage.setResizable(false);
            try {
                memberSelectionStage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            memberSelectionStage.showAndWait();
            return controller.getObject();
        }
        catch (Exception p) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your object selection screen. Please contact support");
            p.printStackTrace();
            alert.showAndWait();
            return "";
        }
    }

    public static void setInputTypeNum(TextField[] textFields) {
        for (TextField t : textFields) {
            t.textProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.matches("\\d*")) {
                    if (oldValue != null) {
                        t.setText(oldValue);
                    } else {
                        t.setText("");
                    }
                }
            });
        }
    }

    public static void setInputTypeDec(TextField[] textFields) {
        for (TextField t : textFields) {
            t.textProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.matches("\\d*([.]\\d{0,4})?")) {
                    if (oldValue != null) {
                        t.setText(oldValue);
                    } else {
                        t.setText("");
                    }
                }
            });
        }
    }

    public static JFXButton getDefaultReportButton() {
        JFXButton btnReport = new JFXButton("Report");
        btnReport.setGraphic((Node)Config.getPDFIcon());
        btnReport.setContentDisplay(ContentDisplay.TOP);
        btnReport.setStyle(Config.getDefaultButtonStyles());
        return btnReport;
    }

    public static JFXButton getDefaultReportButton(String text) {
        JFXButton btnReport = new JFXButton(text);
        btnReport.setGraphic((Node)Config.getPDFIcon());
        btnReport.setContentDisplay(ContentDisplay.TOP);
        btnReport.setStyle(Config.getDefaultButtonStyles());
        return btnReport;
    }

    public void performRecordAction(String action, final Stage stage, String json, User user) {
        try {
            Object controller;
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = null;
            Gson gson = new Gson();
            if (action.equalsIgnoreCase("floors")) {
                itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/floors.fxml").openStream());
                controller = (FloorController)loader.getController();
                ((FloorController)controller).setUser(user);
                ((FloorController)controller).setMyProperty((Property)gson.fromJson(json, Property.class));
                stage.setTitle("Floors");
            } else if (action.equalsIgnoreCase("units")) {
                itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/units.fxml").openStream());
                controller = (UnitsController)loader.getController();
                ((UnitsController)controller).setUser(user);
                ((UnitsController)controller).setMyProperty((Property)gson.fromJson(json, Property.class));
                stage.setTitle("Units");
            } else if (action.equalsIgnoreCase("monthlycharges")) {
                itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/propertymonthlycharges.fxml").openStream());
                controller = (PropertyMonthlyChargesController)loader.getController();
                ((PropertyMonthlyChargesController)controller).setUser(user);
                ((PropertyMonthlyChargesController)controller).setMyProperty((Property)gson.fromJson(json, Property.class));
                stage.setTitle("Monthly Charges");
            } else if (action.equalsIgnoreCase("repay_loan")) {
                itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loan_repayment.fxml").openStream());
                controller = (BankLoanRepaymentController)loader.getController();
                ((BankLoanRepaymentController)controller).setUser(user);
                ((BankLoanRepaymentController)controller).setLoan((Account)gson.fromJson(json, Account.class));
                stage.setTitle("Loan repayment");
            } else {
                GeneralListController.publicNotificationPane.setText("The chosen action could not be found");
                GeneralListController.publicNotificationPane.setGraphic((Node)Config.getTimesIcon());
                GeneralListController.publicNotificationPane.show();
            }
            Scene scene = new Scene((Parent)itemPane);
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.showAndWait();
        }
        catch (Exception p) {
            GeneralListController.publicNotificationPane.setText("An error occurred while loading your new record screen. Please contact support");
            GeneralListController.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
            GeneralListController.publicNotificationPane.show();
            p.printStackTrace();
        }
    }

    public static void sendEmail(String mailRecipient, String mailSubject, String mailBody, String attachment, String friendlyFileName) {
        String to = mailRecipient;
        String from = "payroll@givewatts.org";
        String username = "payroll@givewatts.org";
        String password = "Payroll21";
        String host = "smtp.gmail.com";
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", "25");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("payroll@givewatts.org", "Payroll21");
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            message.setSubject(mailSubject);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(mailBody);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            if (attachment.length() > 0) {
                messageBodyPart = new MimeBodyPart();
                String filename = attachment;
                FileDataSource source = new FileDataSource(filename);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(friendlyFileName);
            }
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public ObservableList<String> getEnumText(String table, String field, User user) {
        ObservableList collection = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("table", table);
        params.put("field", field);
        String response = Config.loadDataFromPhp("masterfetch?type=enumtext", params, user);
        collection = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, String[].class)));
        return collection;
    }

    public JsonResponses checkRequiredFields(ObservableList<String> fields, ObservableList<String> headers, int[] lengths) {
        JsonResponses response = new JsonResponses();
        boolean error = false;
        String message = "";
        try {
            for (int a = 0; a < fields.size(); ++a) {
                String value = ((String)fields.get(a)).trim();
                if (value.length() >= lengths[a]) continue;
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + " Please provide a valid value for " + (String)headers.get(a) + " Atleast " + lengths[a] + " characters";
            }
        }
        catch (Exception y) {
            error = true;
            message = "We encountered an error while validating your input";
        }
        response.setStatus(error);
        response.setMessage(message);
        return response;
    }

    public JsonResponses masterDelete(String type, String json, User user) {
        JsonResponses jr = new JsonResponses();
        jr.setMessage("We enocuntered an error while processing your request. Please try again");
        jr.setStatus(false);
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("type", type);
            params.put("json", json);
            String response = Config.loadDataFromPhp("masterdelete?type=" + type, params, user);
            return (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        }
        catch (Exception exception) {
            return jr;
        }
    }

    public static void exportTableToExcel(String json, String recordType) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        Stage stage = new Stage();
        File file = fileChooser.showSaveDialog((Window)stage);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("Sheet 1");
        int rowCount = 0;
        int columnCount = 0;
        if (file != null) {
            XSSFRow row;
            if (recordType.equalsIgnoreCase("customerreceipt")) {
                row = sheet.createRow(rowCount++);
                row.createCell(columnCount++).setCellValue("Receipt No");
                row.createCell(columnCount++).setCellValue("Customer Name");
                row.createCell(columnCount++).setCellValue("Payment Date");
                row.createCell(columnCount++).setCellValue("Payment method");
                row.createCell(columnCount++).setCellValue("Bank");
                row.createCell(columnCount++).setCellValue("External Ref");
                row.createCell(columnCount++).setCellValue("Amount");
                ObservableList allReceipts = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(json, CustomerReceipt[].class)));
                for (CustomerReceipt receipt : allReceipts) {
                    columnCount = 0;
                    XSSFRow row2 = sheet.createRow(rowCount++);
                    try {
                        row2.createCell(columnCount++).setCellValue(receipt.getReceiptNo());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(receipt.getCustomer().getCustomerName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(receipt.getPaymentDate());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(receipt.getPaymentMethod().getPaymentMethod());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(receipt.getBank().getBankName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(receipt.getExternalRef());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(receipt.getAmount());
                    }
                    catch (Exception exception) {}
                }
            } else if (recordType.equalsIgnoreCase("itemLedgers")) {
                row = sheet.createRow(rowCount++);
                row.createCell(columnCount++).setCellValue("Date");
                row.createCell(columnCount++).setCellValue("Doc No");
                row.createCell(columnCount++).setCellValue("Description");
                row.createCell(columnCount++).setCellValue("Stock In");
                row.createCell(columnCount++).setCellValue("Stock Out");
                row.createCell(columnCount++).setCellValue("Balance");
                row.createCell(columnCount++).setCellValue("Posted By");
                ObservableList allRecords = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(json, LedgerEntries[].class)));
                for (LedgerEntries entry : allRecords) {
                    columnCount = 0;
                    XSSFRow row2 = sheet.createRow(rowCount++);
                    try {
                        row2.createCell(columnCount++).setCellValue(entry.getTransactionDateTime());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(entry.getDocumentNo());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(entry.getDescription());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(entry.getDebit());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(entry.getCredit());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(entry.getBalance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(entry.getPostedBy());
                    }
                    catch (Exception exception) {}
                }
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                workbook.write((OutputStream)outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.close();
        }
    }

    public static void exportTableToExcel(TableView entries) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        Stage stage = new Stage();
        File file = fileChooser.showSaveDialog((Window)stage);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("Sheet 1");
        int rowCount = 0;
        int columnCount = 0;
        if (file != null) {
            XSSFRow row = sheet.createRow(rowCount++);
            ObservableList allColumns = entries.getColumns();
            for (TableColumn column : allColumns) {
                row.createCell(columnCount++).setCellValue(column.getText());
            }
            for (int i = 0; i < entries.getItems().size(); ++i) {
                XSSFRow row2 = sheet.createRow(rowCount++);
                for (int j = 0; j < entries.getColumns().size(); ++j) {
                    if (((TableColumn)allColumns.get(j)).getCellData(i) != null) {
                        row2.createCell(j).setCellValue(((TableColumn)allColumns.get(j)).getCellData(i).toString());
                        continue;
                    }
                    row2.createCell(j).setCellValue("");
                }
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                workbook.write((OutputStream)outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.close();
        }
    }

    public static void sortNumericalColumn(TableColumn column) {
        column.setComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String t, String t1) {
                try {
                    DecimalFormat df = new DecimalFormat("#,###,##0.00");
                    Double d1 = Double.parseDouble(t.replace(",", ""));
                    Double d2 = Double.parseDouble(t1.replace(",", ""));
                    return Double.compare(d1, d2);
                }
                catch (Exception p) {
                    p.printStackTrace();
                    return -1;
                }
            }
        });
    }

    public static void sortHyperlinkColumn(TableColumn column) {
        column.setComparator((Comparator)new Comparator<Hyperlink>(){

            @Override
            public int compare(Hyperlink t, Hyperlink t1) {
                try {
                    DecimalFormat df = new DecimalFormat("#,###,##0.00");
                    Double d1 = Double.parseDouble(t.getText().replace(",", ""));
                    Double d2 = Double.parseDouble(t1.getText().replace(",", ""));
                    return Double.compare(d1, d2);
                }
                catch (Exception p) {
                    p.printStackTrace();
                    return -1;
                }
            }
        });
    }

    public void navigatePosting(String type, String json, User user) {
        System.out.println(type);
        System.out.println(json);
        String documentNo = "";
        String documentDate = "";
        type = type.toLowerCase();
        Gson gson = new Gson();
        if (type.equals("")) {
            SalesHeader sale = (SalesHeader)gson.fromJson(json, SalesHeader.class);
            documentNo = sale.getDocNo();
            documentDate = sale.getSales_date();
        } else if (type.equals("journal")) {
            Journal record = (Journal)gson.fromJson(json, Journal.class);
            documentNo = record.getJournalNo();
            documentDate = record.getTransactionDate();
        } else if (type.equals("vendorinvoice")) {
            PurchaseHeader record = (PurchaseHeader)gson.fromJson(json, PurchaseHeader.class);
            documentNo = record.getDocumentNo();
            documentDate = record.getInvoiceDate();
        } else if (type.equalsIgnoreCase("salesinvoice") || type.equalsIgnoreCase("expresssale") || type.equalsIgnoreCase("creditnote")) {
            SalesHeader invoice = (SalesHeader)gson.fromJson(json, SalesHeader.class);
            documentNo = invoice.getDoc_no();
            documentDate = invoice.getSales_date();
        } else if (type.equals("memberreceipt")) {
            Receipt record = (Receipt)gson.fromJson(json, Receipt.class);
            documentNo = record.getReceiptNo();
            documentDate = record.getPaymentDate();
        } else if (type.equals("bulkreceipt")) {
            Receipt record = (Receipt)gson.fromJson(json, Receipt.class);
            documentNo = record.getReceiptNo();
            documentDate = record.getPaymentDate();
        } else if (type.equals("loanrecovered")) {
            RecoverLoan record = (RecoverLoan)gson.fromJson(json, RecoverLoan.class);
            documentNo = record.getRecoveryNo();
            documentDate = record.getRecoveryDate();
        } else if (type.equals("transferfunds")) {
            TransferFunds record = (TransferFunds)gson.fromJson(json, TransferFunds.class);
            documentNo = record.getTransferNo();
            documentDate = record.getTransferDate();
        } else if (type.equals("savingswithdrawal")) {
            CashWithdrawal record = (CashWithdrawal)gson.fromJson(json, CashWithdrawal.class);
            documentNo = record.getVoucherNo();
            documentDate = record.getWithdrawalDate();
        } else if (type.equals("issuedloan")) {
            Loan record = (Loan)gson.fromJson(json, Loan.class);
            documentNo = record.getLoanNumber();
            documentDate = record.getIssuedOn().split(" ")[0];
        } else if (type.equals("endofday")) {
            SalesHeader record = (SalesHeader)gson.fromJson(json, SalesHeader.class);
            documentNo = record.getDocNo();
            documentDate = record.getSales_date().split(" ")[0];
        }
        this.navigateRecord(documentDate, documentNo, user);
    }

    public void navigateRecord(String date, String documentNo, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            final Stage stage = new Stage();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/navigate.fxml").openStream());
            Scene scene = new Scene((Parent)itemPane);
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            NavigationController controller = (NavigationController)loader.getController();
            controller.setUser(user);
            controller.setDocumentDate(date);
            controller.setDocumentNo(documentNo);
            stage.setTitle("View Navigation");
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your navigation screen. Please contact support");
            alert.showAndWait();
        }
    }

    public void showDatesFilter(User user, String reportName, String stageName) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            PNLFilter controller = (PNLFilter)loader.getController();
            controller.setUser(user);
            controller.setReportName(reportName);
            stage.setTitle(stageName);
            stage.setResizable(false);
            stage.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadMasterRollReport(String reportName, String stageName, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/masterrollfilter.fxml").openStream());
            MasterRollFilter controller = (MasterRollFilter)loader.getController();
            controller.setUser(user);
            controller.setReportName(reportName);
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            stage.setTitle(stageName);
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
        }
    }

    public void loadItemsFilter(String reportName, String stageName, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/allitemsfilter.fxml").openStream());
            AllItemsFilterController controller = (AllItemsFilterController)loader.getController();
            controller.setUser(user);
            controller.setReportName(reportName);
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            stage.setTitle(stageName);
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
        }
    }

    public void loadCustomerPNLFilter(String reportName, String json, String title, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            Customer customer = (Customer)new Gson().fromJson(json, Customer.class);
            PNLFilter controller = (PNLFilter)loader.getController();
            controller.setUser(user);
            controller.setReportName(reportName);
            controller.setCustomer(customer);
            stage.setTitle(title);
            stage.setResizable(false);
            stage.show();
        }
        catch (Exception p) {
            p.printStackTrace();
        }
    }

    public void loadVendorPNLFilter(String reportName, String json, String title, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            Vendor vendor = (Vendor)new Gson().fromJson(json, Vendor.class);
            PNLFilter controller = (PNLFilter)loader.getController();
            controller.setUser(user);
            controller.setReportName(reportName);
            controller.setVendor(vendor);
            stage.setTitle(title);
            stage.setResizable(false);
            stage.show();
        }
        catch (Exception p) {
            p.printStackTrace();
        }
    }

    public static long getCurrentSystemTime() {
        long seconds = System.currentTimeMillis() / 1000L;
        return seconds;
    }

    public String amountInWords(double amount) {
        int ones;
        String amountInWords = "";
        System.out.print(Config.formatNumber(amount) + " ");
        double trillion = 1.0E12;
        double billion = 1.0E9;
        double million = 1000000.0;
        double thousand = 1000.0;
        if (amount > trillion) {
            int trillions = (int)(amount / trillion);
            amountInWords = amountInWords + this.convertToText(trillions) + " Trillion ";
            amount -= (double)trillions * trillion;
        }
        if (amount > billion) {
            int billions = (int)(amount / billion);
            amountInWords = amountInWords + this.convertToText(billions) + " Billions ";
            amount -= (double)billions * billion;
        }
        if (amount > million) {
            int millions = (int)(amount / million);
            amountInWords = amountInWords + this.convertToText(millions) + " Million ";
            amount -= (double)millions * million;
        }
        if (amount > thousand) {
            int thousands = (int)(amount / thousand);
            amountInWords = amountInWords + this.convertToText(thousands) + " Thousand ";
            amount -= (double)thousands * thousand;
        }
        if (amount > 0.0 && (ones = (int)(amount / 1.0)) > 0) {
            amountInWords = amountInWords + this.convertToText(ones);
            amount -= (double)(ones * 1);
        }
        if (amount > 0.0) {
            String decimals = (double)Math.round(amount * 100.0) / 100.0 + "";
            amountInWords = amountInWords + "." + decimals.substring(2);
        }
        return amountInWords + " Only";
    }

    public String convertToText(int figure) {
        String[] ones = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Xixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty"};
        String[] tens = new String[]{"Zero", "One", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"};
        String words = "";
        if (figure < 20) {
            words = ones[figure];
        } else if (figure < 100) {
            int res = figure / 10;
            words = tens[res];
            int postPrefix = figure % 10;
            if (postPrefix > 0) {
                words = words + " " + ones[postPrefix];
            }
        } else if (figure < 1000) {
            int res = figure / 100;
            words = ones[res];
            words = words + " Hundred";
            int postFixFigure = figure % 100;
            if (postFixFigure > 0) {
                String postFix = this.convertToText(postFixFigure);
                words = words + (postFix.length() > 0 ? " and " : " ");
                words = words + postFix;
            }
        }
        return words;
    }

    public static String getSystemTime() {
        return DateTimeFormatter.ofPattern("dd/MM/yyyy/ HH:mm:ss").format(LocalDateTime.now());
    }
}

