/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.User;
import com.google.gson.Gson;
import filterscontrollers.BankStatementFilter;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class Bank {
    private int code;
    private String bankName;
    private String bankBranch;
    private String bankAccount;
    private double balance;
    private String lastTransactionDate;
    private Boolean enabled;
    private String addedBy;
    private String addedOn;
    private String balanceString;

    public Bank(int code) {
        this.code = code;
    }

    public Bank(int code, String bankName, String bankBranch, String bankAccount, double balance, String lastTransactionDate, Boolean enabled, String addedBy, String addedOn) {
        this.code = code;
        this.bankName = bankName;
        this.bankBranch = bankBranch;
        this.bankAccount = bankAccount;
        this.balance = balance;
        this.lastTransactionDate = lastTransactionDate;
        this.enabled = enabled;
        this.addedBy = addedBy;
        this.addedOn = addedOn;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankBranch() {
        return this.bankBranch;
    }

    public void setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public String getLastTransactionDate() {
        return this.lastTransactionDate;
    }

    public void setLastTransactionDate(String lastTransactionDate) {
        this.lastTransactionDate = lastTransactionDate;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public String getAddedOn() {
        return this.addedOn;
    }

    public void setAddedOn(String addedOn) {
        this.addedOn = addedOn;
    }

    public String getBalanceString() {
        return Config.formatNumber(this.balance);
    }

    public void setBalanceString(String balanceString) {
        this.balanceString = balanceString;
    }

    public static ObservableList<Bank> getAllBanks(User user) {
        ObservableList allBanks = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=banks", params, user);
            Gson g = new Gson();
            Object[] banksFromJson = (Bank[])g.fromJson(response, Bank[].class);
            allBanks = FXCollections.observableArrayList((Object[])banksFromJson);
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return allBanks;
    }

    public String toString() {
        return this.bankName + " - " + this.bankAccount;
    }

    public void generateStatement(User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/bankstatement.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            BankStatementFilter controller = (BankStatementFilter)loader.getController();
            controller.setUser(user);
            controller.setMyBank(this);
            stage.setTitle("Bank Statement filter");
            stage.setResizable(false);
            stage.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class BankBalance {
        private int id;
        private String date;
        private Bank bank;
        private double balance;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public Bank getBank() {
            return this.bank;
        }

        public void setBank(Bank bank) {
            this.bank = bank;
        }

        public double getBalance() {
            return this.balance;
        }

        public String getBalanceString() {
            return Config.formatNumber(this.balance);
        }

        public void setBalance(double balance) {
            this.balance = balance;
        }
    }
}

