/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Account;
import classes.Config;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;

public class AllowancesDeductions {
    private String code;
    private String name;
    private Vendor vendor;
    private Account glAccount;
    private boolean taxable;
    private boolean disabled;
    private String type;
    private boolean loanAdvance;
    private boolean statutory;
    private String addedOn;
    private String addedBy;
    private String vendorGlAccount;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public Account getGlAccount() {
        return this.glAccount;
    }

    public void setGlAccount(Account glAccount) {
        this.glAccount = glAccount;
    }

    public boolean isTaxable() {
        return this.taxable;
    }

    public void setTaxable(boolean taxable) {
        this.taxable = taxable;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isStatutory() {
        return this.statutory;
    }

    public void setStatutory(boolean statutory) {
        this.statutory = statutory;
    }

    public String getAddedOn() {
        return this.addedOn;
    }

    public void setAddedOn(String addedOn) {
        this.addedOn = addedOn;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public boolean isLoanAdvance() {
        return this.loanAdvance;
    }

    public void setLoanAdvance(boolean loanAdvance) {
        this.loanAdvance = loanAdvance;
    }

    public String getVendorGlAccount() {
        if (this.isLoanAdvance()) {
            return this.getGlAccount().getAccountName();
        }
        return this.getVendor().getFullName();
    }

    public void setVendorGlAccount(String vendorGlAccount) {
        this.vendorGlAccount = vendorGlAccount;
    }

    public CheckBox getTaxableCheckbox() {
        CheckBox checkbox = new CheckBox();
        checkbox.setSelected(this.isTaxable());
        checkbox.setDisable(true);
        return checkbox;
    }

    public CheckBox getDisabledCheckbox() {
        CheckBox checkbox = new CheckBox();
        checkbox.setSelected(this.isDisabled());
        checkbox.setDisable(true);
        return checkbox;
    }

    public ObservableList<AllowancesDeductions> getAllAllowances(User user) {
        ObservableList allEntries = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String response = Config.loadDataFromPhp("masterfetch?type=payrollallowances", params, user);
        System.out.println(response);
        allEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, AllowancesDeductions[].class)));
        return allEntries;
    }

    public ObservableList<AllowancesDeductions> getAllDeductions(User user) {
        ObservableList allEntries = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String response = Config.loadDataFromPhp("masterfetch?type=payrolldeductions", params, user);
        System.out.println(response);
        allEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, AllowancesDeductions[].class)));
        return allEntries;
    }

    public String toString() {
        return this.name;
    }
}

